/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param.billing;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class CreditGrantCreateParams
extends ApiRequestParams {
    @SerializedName(value="amount")
    Amount amount;
    @SerializedName(value="applicability_config")
    ApplicabilityConfig applicabilityConfig;
    @SerializedName(value="category")
    Category category;
    @SerializedName(value="customer")
    String customer;
    @SerializedName(value="effective_at")
    Long effectiveAt;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="expires_at")
    Long expiresAt;
    @SerializedName(value="_stripe_java_extra_param_key")
    Map<String, Object> extraParams;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="name")
    String name;

    private CreditGrantCreateParams(Amount amount, ApplicabilityConfig applicabilityConfig, Category category, String customer, Long effectiveAt, List<String> expand, Long expiresAt, Map<String, Object> extraParams, Map<String, String> metadata, String name) {
        this.amount = amount;
        this.applicabilityConfig = applicabilityConfig;
        this.category = category;
        this.customer = customer;
        this.effectiveAt = effectiveAt;
        this.expand = expand;
        this.expiresAt = expiresAt;
        this.extraParams = extraParams;
        this.metadata = metadata;
        this.name = name;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public Amount getAmount() {
        return this.amount;
    }

    @Generated
    public ApplicabilityConfig getApplicabilityConfig() {
        return this.applicabilityConfig;
    }

    @Generated
    public Category getCategory() {
        return this.category;
    }

    @Generated
    public String getCustomer() {
        return this.customer;
    }

    @Generated
    public Long getEffectiveAt() {
        return this.effectiveAt;
    }

    @Generated
    public List<String> getExpand() {
        return this.expand;
    }

    @Generated
    public Long getExpiresAt() {
        return this.expiresAt;
    }

    @Generated
    public Map<String, Object> getExtraParams() {
        return this.extraParams;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    public static class Amount {
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="monetary")
        Monetary monetary;
        @SerializedName(value="type")
        Type type;

        private Amount(Map<String, Object> extraParams, Monetary monetary, Type type) {
            this.extraParams = extraParams;
            this.monetary = monetary;
            this.type = type;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public Monetary getMonetary() {
            return this.monetary;
        }

        @Generated
        public Type getType() {
            return this.type;
        }

        public static class Monetary {
            @SerializedName(value="currency")
            String currency;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="value")
            Long value;

            private Monetary(String currency, Map<String, Object> extraParams, Long value) {
                this.currency = currency;
                this.extraParams = extraParams;
                this.value = value;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public String getCurrency() {
                return this.currency;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Long getValue() {
                return this.value;
            }

            public static class Builder {
                private String currency;
                private Map<String, Object> extraParams;
                private Long value;

                public Monetary build() {
                    return new Monetary(this.currency, this.extraParams, this.value);
                }

                public Builder setCurrency(String currency) {
                    this.currency = currency;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setValue(Long value) {
                    this.value = value;
                    return this;
                }
            }
        }

        public static enum Type implements ApiRequestParams.EnumParam
        {
            MONETARY("monetary");

            private final String value;

            private Type(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class Builder {
            private Map<String, Object> extraParams;
            private Monetary monetary;
            private Type type;

            public Amount build() {
                return new Amount(this.extraParams, this.monetary, this.type);
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setMonetary(Monetary monetary) {
                this.monetary = monetary;
                return this;
            }

            public Builder setType(Type type) {
                this.type = type;
                return this;
            }
        }
    }

    public static class ApplicabilityConfig {
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="scope")
        Scope scope;

        private ApplicabilityConfig(Map<String, Object> extraParams, Scope scope) {
            this.extraParams = extraParams;
            this.scope = scope;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public Scope getScope() {
            return this.scope;
        }

        public static class Scope {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="price_type")
            PriceType priceType;

            private Scope(Map<String, Object> extraParams, PriceType priceType) {
                this.extraParams = extraParams;
                this.priceType = priceType;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public PriceType getPriceType() {
                return this.priceType;
            }

            public static enum PriceType implements ApiRequestParams.EnumParam
            {
                METERED("metered");

                private final String value;

                private PriceType(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private PriceType priceType;

                public Scope build() {
                    return new Scope(this.extraParams, this.priceType);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setPriceType(PriceType priceType) {
                    this.priceType = priceType;
                    return this;
                }
            }
        }

        public static class Builder {
            private Map<String, Object> extraParams;
            private Scope scope;

            public ApplicabilityConfig build() {
                return new ApplicabilityConfig(this.extraParams, this.scope);
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setScope(Scope scope) {
                this.scope = scope;
                return this;
            }
        }
    }

    public static enum Category implements ApiRequestParams.EnumParam
    {
        PAID("paid"),
        PROMOTIONAL("promotional");

        private final String value;

        private Category(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class Builder {
        private Amount amount;
        private ApplicabilityConfig applicabilityConfig;
        private Category category;
        private String customer;
        private Long effectiveAt;
        private List<String> expand;
        private Long expiresAt;
        private Map<String, Object> extraParams;
        private Map<String, String> metadata;
        private String name;

        public CreditGrantCreateParams build() {
            return new CreditGrantCreateParams(this.amount, this.applicabilityConfig, this.category, this.customer, this.effectiveAt, this.expand, this.expiresAt, this.extraParams, this.metadata, this.name);
        }

        public Builder setAmount(Amount amount) {
            this.amount = amount;
            return this;
        }

        public Builder setApplicabilityConfig(ApplicabilityConfig applicabilityConfig) {
            this.applicabilityConfig = applicabilityConfig;
            return this;
        }

        public Builder setCategory(Category category) {
            this.category = category;
            return this;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setEffectiveAt(Long effectiveAt) {
            this.effectiveAt = effectiveAt;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder setExpiresAt(Long expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public Builder putExtraParam(String key, Object value) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.put(key, value);
            return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.putAll(map);
            return this;
        }

        public Builder putMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public Builder putAllMetadata(Map<String, String> map) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.putAll(map);
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }
    }
}

