/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cbs.v20170312.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class InquirePriceModifyDiskBackupQuotaResponse extends AbstractModel{

    /**
    * 描述了修改云硬盘备份点之后的云盘价格。
    */
    @SerializedName("DiskPrice")
    @Expose
    private Price DiskPrice;

    /**
    * 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get 描述了修改云硬盘备份点之后的云盘价格。 
     * @return DiskPrice 描述了修改云硬盘备份点之后的云盘价格。
     */
    public Price getDiskPrice() {
        return this.DiskPrice;
    }

    /**
     * Set 描述了修改云硬盘备份点之后的云盘价格。
     * @param DiskPrice 描述了修改云硬盘备份点之后的云盘价格。
     */
    public void setDiskPrice(Price DiskPrice) {
        this.DiskPrice = DiskPrice;
    }

    /**
     * Get 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。 
     * @return RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     * @param RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public InquirePriceModifyDiskBackupQuotaResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public InquirePriceModifyDiskBackupQuotaResponse(InquirePriceModifyDiskBackupQuotaResponse source) {
        if (source.DiskPrice != null) {
            this.DiskPrice = new Price(source.DiskPrice);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamObj(map, prefix + "DiskPrice.", this.DiskPrice);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

