/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.taf.v20200210.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class OutputRecognizeTargetAudienceValue extends AbstractModel{

    /**
    * 模型ID
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("ModelId")
    @Expose
    private Long ModelId;

    /**
    * 是否正常返回结果
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("IsFound")
    @Expose
    private Long IsFound;

    /**
    * 返回分值
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("Score")
    @Expose
    private Float Score;

    /**
    * 模型类型
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("ModelType")
    @Expose
    private Long ModelType;

    /**
    * 入参Uid
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("Uid")
    @Expose
    private String Uid;

    /**
     * Get 模型ID
注意：此字段可能返回 null，表示取不到有效值。 
     * @return ModelId 模型ID
注意：此字段可能返回 null，表示取不到有效值。
     */
    public Long getModelId() {
        return this.ModelId;
    }

    /**
     * Set 模型ID
注意：此字段可能返回 null，表示取不到有效值。
     * @param ModelId 模型ID
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setModelId(Long ModelId) {
        this.ModelId = ModelId;
    }

    /**
     * Get 是否正常返回结果
注意：此字段可能返回 null，表示取不到有效值。 
     * @return IsFound 是否正常返回结果
注意：此字段可能返回 null，表示取不到有效值。
     */
    public Long getIsFound() {
        return this.IsFound;
    }

    /**
     * Set 是否正常返回结果
注意：此字段可能返回 null，表示取不到有效值。
     * @param IsFound 是否正常返回结果
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setIsFound(Long IsFound) {
        this.IsFound = IsFound;
    }

    /**
     * Get 返回分值
注意：此字段可能返回 null，表示取不到有效值。 
     * @return Score 返回分值
注意：此字段可能返回 null，表示取不到有效值。
     */
    public Float getScore() {
        return this.Score;
    }

    /**
     * Set 返回分值
注意：此字段可能返回 null，表示取不到有效值。
     * @param Score 返回分值
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setScore(Float Score) {
        this.Score = Score;
    }

    /**
     * Get 模型类型
注意：此字段可能返回 null，表示取不到有效值。 
     * @return ModelType 模型类型
注意：此字段可能返回 null，表示取不到有效值。
     */
    public Long getModelType() {
        return this.ModelType;
    }

    /**
     * Set 模型类型
注意：此字段可能返回 null，表示取不到有效值。
     * @param ModelType 模型类型
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setModelType(Long ModelType) {
        this.ModelType = ModelType;
    }

    /**
     * Get 入参Uid
注意：此字段可能返回 null，表示取不到有效值。 
     * @return Uid 入参Uid
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getUid() {
        return this.Uid;
    }

    /**
     * Set 入参Uid
注意：此字段可能返回 null，表示取不到有效值。
     * @param Uid 入参Uid
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setUid(String Uid) {
        this.Uid = Uid;
    }

    public OutputRecognizeTargetAudienceValue() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public OutputRecognizeTargetAudienceValue(OutputRecognizeTargetAudienceValue source) {
        if (source.ModelId != null) {
            this.ModelId = new Long(source.ModelId);
        }
        if (source.IsFound != null) {
            this.IsFound = new Long(source.IsFound);
        }
        if (source.Score != null) {
            this.Score = new Float(source.Score);
        }
        if (source.ModelType != null) {
            this.ModelType = new Long(source.ModelType);
        }
        if (source.Uid != null) {
            this.Uid = new String(source.Uid);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "ModelId", this.ModelId);
        this.setParamSimple(map, prefix + "IsFound", this.IsFound);
        this.setParamSimple(map, prefix + "Score", this.Score);
        this.setParamSimple(map, prefix + "ModelType", this.ModelType);
        this.setParamSimple(map, prefix + "Uid", this.Uid);

    }
}

