/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.tcss.v20201101.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class CreateSearchTemplateRequest extends AbstractModel{

    /**
    * 搜索模板
    */
    @SerializedName("SearchTemplate")
    @Expose
    private SearchTemplate SearchTemplate;

    /**
     * Get 搜索模板 
     * @return SearchTemplate 搜索模板
     */
    public SearchTemplate getSearchTemplate() {
        return this.SearchTemplate;
    }

    /**
     * Set 搜索模板
     * @param SearchTemplate 搜索模板
     */
    public void setSearchTemplate(SearchTemplate SearchTemplate) {
        this.SearchTemplate = SearchTemplate;
    }

    public CreateSearchTemplateRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public CreateSearchTemplateRequest(CreateSearchTemplateRequest source) {
        if (source.SearchTemplate != null) {
            this.SearchTemplate = new SearchTemplate(source.SearchTemplate);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamObj(map, prefix + "SearchTemplate.", this.SearchTemplate);

    }
}

