/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.textfield;

import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.CompositionNotifier;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasAriaLabel;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasHelper;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.InputNotifier;
import com.vaadin.flow.component.KeyNotifier;
import com.vaadin.flow.component.shared.HasClearButton;
import com.vaadin.flow.component.shared.HasClientValidation;
import com.vaadin.flow.component.shared.HasTooltip;
import com.vaadin.flow.component.shared.HasValidationProperties;
import com.vaadin.flow.component.shared.SlotUtils;
import com.vaadin.flow.component.textfield.HasAutocapitalize;
import com.vaadin.flow.component.textfield.HasAutocomplete;
import com.vaadin.flow.component.textfield.HasAutocorrect;
import com.vaadin.flow.component.textfield.HasPrefixAndSuffix;
import com.vaadin.flow.data.binder.HasValidator;
import com.vaadin.flow.data.value.HasValueChangeMode;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.function.SerializableFunction;
import java.util.Optional;

public abstract class TextFieldBase<TComponent extends TextFieldBase<TComponent, TValue>, TValue>
extends AbstractSinglePropertyField<TComponent, TValue>
implements CompositionNotifier,
Focusable<TComponent>,
HasAriaLabel,
HasAutocapitalize,
HasAutocomplete,
HasAutocorrect,
HasClearButton,
HasClientValidation,
HasHelper,
HasLabel,
HasPrefixAndSuffix,
HasSize,
HasStyle,
HasTooltip,
HasValidationProperties,
HasValidator<TValue>,
HasValueChangeMode,
InputNotifier,
KeyNotifier {
    private ValueChangeMode currentMode;
    private int valueChangeTimeout = 400;

    public ValueChangeMode getValueChangeMode() {
        return this.currentMode;
    }

    public void setValueChangeMode(ValueChangeMode valueChangeMode) {
        this.currentMode = valueChangeMode;
        this.setSynchronizedEvent(ValueChangeMode.eventForMode((ValueChangeMode)valueChangeMode, (String)"value-changed"));
        this.applyChangeTimeout();
    }

    public void setValueChangeTimeout(int valueChangeTimeout) {
        this.valueChangeTimeout = valueChangeTimeout;
        this.applyChangeTimeout();
    }

    public int getValueChangeTimeout() {
        return this.valueChangeTimeout;
    }

    private void applyChangeTimeout() {
        ValueChangeMode.applyChangeTimeout((ValueChangeMode)this.getValueChangeMode(), (int)this.getValueChangeTimeout(), (DomListenerRegistration)this.getSynchronizationRegistration());
    }

    public void setPlaceholder(String placeholder) {
        this.getElement().setProperty("placeholder", placeholder == null ? "" : placeholder);
    }

    public String getPlaceholder() {
        return this.getElement().getProperty("placeholder");
    }

    public void setAutofocus(boolean autofocus) {
        this.getElement().setProperty("autofocus", autofocus);
    }

    public boolean isAutofocus() {
        return this.getElement().getProperty("autofocus", false);
    }

    public String getTitle() {
        return this.getElement().getProperty("title");
    }

    public void setTitle(String title) {
        this.getElement().setProperty("title", title == null ? "" : title);
    }

    public boolean isAutoselect() {
        return this.getElement().getProperty("autoselect", false);
    }

    public void setAutoselect(boolean autoselect) {
        this.getElement().setProperty("autoselect", autoselect);
    }

    public void setRequired(boolean required) {
        this.getElement().setProperty("required", required);
    }

    public boolean isRequired() {
        return this.getElement().getProperty("required", false);
    }

    public void setLabel(String label) {
        super.setLabel(label);
    }

    public void setAriaLabel(String ariaLabel) {
        this.getElement().setProperty("accessibleName", ariaLabel);
    }

    public Optional<String> getAriaLabel() {
        return Optional.ofNullable(this.getElement().getProperty("accessibleName"));
    }

    public void setAriaLabelledBy(String labelledBy) {
        this.getElement().setProperty("accessibleNameRef", labelledBy);
    }

    public Optional<String> getAriaLabelledBy() {
        return Optional.ofNullable(this.getElement().getProperty("accessibleNameRef"));
    }

    protected void addToPrefix(Component ... components) {
        SlotUtils.addToSlot((HasElement)this, (String)"prefix", (Component[])components);
    }

    protected void addToInput(Component ... components) {
        SlotUtils.addToSlot((HasElement)this, (String)"input", (Component[])components);
    }

    protected void addToSuffix(Component ... components) {
        SlotUtils.addToSlot((HasElement)this, (String)"suffix", (Component[])components);
    }

    <P> TextFieldBase(TValue initialValue, TValue defaultValue, Class<P> elementPropertyType, SerializableFunction<P, TValue> presentationToModel, SerializableFunction<TValue, P> modelToPresentation, boolean isInitialValueOptional) {
        super("value", defaultValue, elementPropertyType, presentationToModel, modelToPresentation);
        if (!(this.getElement().getProperty("value") != null && isInitialValueOptional || initialValue == null)) {
            this.setPresentationValue(initialValue);
        }
    }

    <P> TextFieldBase(TValue initialValue, TValue defaultValue, Class<P> elementPropertyType, SerializableBiFunction<TComponent, P, TValue> presentationToModel, SerializableBiFunction<TComponent, TValue, P> modelToPresentation, boolean isInitialValueOptional) {
        super("value", defaultValue, elementPropertyType, presentationToModel, modelToPresentation);
        if (!(this.getElement().getProperty("value") != null && isInitialValueOptional || initialValue == null)) {
            this.setPresentationValue(initialValue);
        }
    }

    TextFieldBase(TValue initialValue, TValue defaultValue, boolean acceptNullValues, boolean isInitialValueOptional) {
        super("value", defaultValue, acceptNullValues);
        if (!(this.getElement().getProperty("value") != null && isInitialValueOptional || initialValue == null)) {
            this.setPresentationValue(initialValue);
        }
    }
}

