/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.live;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.parser.Feature;
import com.volcengine.model.ServiceInfo;
import com.volcengine.model.live.DescribeLivePullToPushDataBody;
import com.volcengine.model.live.DescribeLivePullToPushDataRes;
import com.volcengine.model.live.DescribeLiveRecordDataBody;
import com.volcengine.model.live.DescribeLiveRecordDataRes;
import com.volcengine.model.live.DescribeLiveSnapshotDataBody;
import com.volcengine.model.live.DescribeLiveSnapshotDataRes;
import com.volcengine.model.live.DescribeLiveTranscodeDataBody;
import com.volcengine.model.live.DescribeLiveTranscodeDataRes;
import com.volcengine.model.response.RawResponse;
import com.volcengine.model.response.ResponseMetadata;
import com.volcengine.service.BaseServiceImpl;
import com.volcengine.service.live.LiveConfig;

public class LiveTrait
extends BaseServiceImpl {
    protected LiveTrait() {
        super(LiveConfig.serviceInfoMap.get("cn-north-1"), LiveConfig.apiInfoList);
    }

    protected LiveTrait(ServiceInfo serviceInfo) {
        super(serviceInfo, LiveConfig.apiInfoList);
    }

    private <T> T parseRawResponse(RawResponse rawResponse, Class<T> type) throws Exception {
        Exception ex = rawResponse.getException();
        if (ex != null) {
            throw ex;
        }
        byte[] data = rawResponse.getData();
        if (data == null) {
            throw new Exception("null response body got, rawResponse:" + JSON.toJSONString((Object)rawResponse));
        }
        ResponseModel resp = (ResponseModel)JSON.parseObject((byte[])data, ResponseModel.class, (Feature[])new Feature[0]);
        ResponseMetadata responseMetadata = resp.getResponseMetadata();
        if (responseMetadata == null) {
            return (T)JSON.parseObject((byte[])data, type, (Feature[])new Feature[0]);
        }
        ResponseMetadata.Error err = responseMetadata.getError();
        if (err != null) {
            throw new Exception(String.format("API Error: LogID:%s ErrorCode:%s(%d) %s, rawResponse:%s", resp.getResponseMetadata().getRequestId(), err.getCode(), err.getCodeN(), err.getMessage(), JSON.toJSONString((Object)rawResponse)));
        }
        return (T)JSON.parseObject((byte[])data, type, (Feature[])new Feature[0]);
    }

    public DescribeLiveSnapshotDataRes describeLiveSnapshotData(DescribeLiveSnapshotDataBody body) throws Exception {
        RawResponse rawResponse = this.json("DescribeLiveSnapshotData", null, JSON.toJSONString((Object)body));
        return this.parseRawResponse(rawResponse, DescribeLiveSnapshotDataRes.class);
    }

    public DescribeLiveRecordDataRes describeLiveRecordData(DescribeLiveRecordDataBody body) throws Exception {
        RawResponse rawResponse = this.json("DescribeLiveRecordData", null, JSON.toJSONString((Object)body));
        return this.parseRawResponse(rawResponse, DescribeLiveRecordDataRes.class);
    }

    public DescribeLiveTranscodeDataRes describeLiveTranscodeData(DescribeLiveTranscodeDataBody body) throws Exception {
        RawResponse rawResponse = this.json("DescribeLiveTranscodeData", null, JSON.toJSONString((Object)body));
        return this.parseRawResponse(rawResponse, DescribeLiveTranscodeDataRes.class);
    }

    public DescribeLivePullToPushDataRes describeLivePullToPushData(DescribeLivePullToPushDataBody body) throws Exception {
        RawResponse rawResponse = this.json("DescribeLivePullToPushData", null, JSON.toJSONString((Object)body));
        return this.parseRawResponse(rawResponse, DescribeLivePullToPushDataRes.class);
    }

    public static class ResponseModel {
        @JSONField(name="ResponseMetadata")
        private ResponseMetadata responseMetadata;

        public ResponseMetadata getResponseMetadata() {
            return this.responseMetadata;
        }

        public void setResponseMetadata(ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResponseModel)) {
                return false;
            }
            ResponseModel other = (ResponseModel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ResponseMetadata this$responseMetadata = this.getResponseMetadata();
            ResponseMetadata other$responseMetadata = other.getResponseMetadata();
            return !(this$responseMetadata == null ? other$responseMetadata != null : !((Object)this$responseMetadata).equals(other$responseMetadata));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ResponseModel;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ResponseMetadata $responseMetadata = this.getResponseMetadata();
            result = result * 59 + ($responseMetadata == null ? 43 : ((Object)$responseMetadata).hashCode());
            return result;
        }

        public String toString() {
            return "LiveTrait.ResponseModel(responseMetadata=" + this.getResponseMetadata() + ")";
        }
    }
}

