/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.core.thread;

import com.xxl.job.core.biz.AdminBiz;
import com.xxl.job.core.biz.model.RegistryParam;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.enums.RegistryConfig;
import com.xxl.job.core.executor.XxlJobExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorRegistryThread {
    private static Logger logger = LoggerFactory.getLogger(ExecutorRegistryThread.class);
    private static ExecutorRegistryThread instance = new ExecutorRegistryThread();
    private Thread registryThread;
    private volatile boolean toStop = false;

    public static ExecutorRegistryThread getInstance() {
        return instance;
    }

    public void start(final String appname, final String address) {
        if (appname == null || appname.trim().length() == 0) {
            logger.warn(">>>>>>>>>>> xxl-job, executor registry config fail, appname is null.");
            return;
        }
        if (XxlJobExecutor.getAdminBizList() == null) {
            logger.warn(">>>>>>>>>>> xxl-job, executor registry config fail, adminAddresses is null.");
            return;
        }
        this.registryThread = new Thread(new Runnable(){
            final /* synthetic */ ExecutorRegistryThread this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                block16: {
                    ReturnT<String> registryResult;
                    RegistryParam registryParam;
                    while (!this.this$0.toStop) {
                        block15: {
                            try {
                                registryParam = new RegistryParam(RegistryConfig.RegistType.EXECUTOR.name(), appname, address);
                                for (AdminBiz adminBiz : XxlJobExecutor.getAdminBizList()) {
                                    try {
                                        registryResult = adminBiz.registry(registryParam);
                                        if (registryResult != null && 200 == registryResult.getCode()) {
                                            registryResult = ReturnT.SUCCESS;
                                            logger.debug(">>>>>>>>>>> xxl-job registry success, registryParam:{}, registryResult:{}", new Object[]{registryParam, registryResult});
                                            break;
                                        }
                                        logger.info(">>>>>>>>>>> xxl-job registry fail, registryParam:{}, registryResult:{}", new Object[]{registryParam, registryResult});
                                    }
                                    catch (Exception e) {
                                        logger.info(">>>>>>>>>>> xxl-job registry error, registryParam:{}", (Object)registryParam, (Object)e);
                                    }
                                }
                            }
                            catch (Exception e) {
                                if (this.this$0.toStop) break block15;
                                logger.error(e.getMessage(), (Throwable)e);
                            }
                        }
                        try {
                            if (this.this$0.toStop) continue;
                            TimeUnit.SECONDS.sleep(30L);
                        }
                        catch (InterruptedException e) {
                            if (this.this$0.toStop) continue;
                            logger.warn(">>>>>>>>>>> xxl-job, executor registry thread interrupted, error msg:{}", (Object)e.getMessage());
                        }
                    }
                    try {
                        registryParam = new RegistryParam(RegistryConfig.RegistType.EXECUTOR.name(), appname, address);
                        for (AdminBiz adminBiz : XxlJobExecutor.getAdminBizList()) {
                            try {
                                registryResult = adminBiz.registryRemove(registryParam);
                                if (registryResult != null && 200 == registryResult.getCode()) {
                                    registryResult = ReturnT.SUCCESS;
                                    logger.info(">>>>>>>>>>> xxl-job registry-remove success, registryParam:{}, registryResult:{}", new Object[]{registryParam, registryResult});
                                    break;
                                }
                                logger.info(">>>>>>>>>>> xxl-job registry-remove fail, registryParam:{}, registryResult:{}", new Object[]{registryParam, registryResult});
                            }
                            catch (Exception e) {
                                if (this.this$0.toStop) continue;
                                logger.info(">>>>>>>>>>> xxl-job registry-remove error, registryParam:{}", (Object)registryParam, (Object)e);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (this.this$0.toStop) break block16;
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                logger.info(">>>>>>>>>>> xxl-job, executor registry thread destroy.");
            }
        });
        this.registryThread.setDaemon(true);
        this.registryThread.setName("xxl-job, executor ExecutorRegistryThread");
        this.registryThread.start();
    }

    public void toStop() {
        this.toStop = true;
        if (this.registryThread != null) {
            this.registryThread.interrupt();
            try {
                this.registryThread.join();
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

