/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop;

import com.yeepay.g3.sdk.yop.YopClientConfiguration;
import com.yeepay.g3.sdk.yop.auth.YopSignOptions;
import com.yeepay.g3.sdk.yop.auth.YopV2Signer;
import com.yeepay.g3.sdk.yop.exception.YopClientException;
import com.yeepay.g3.sdk.yop.http.HttpMethodName;
import com.yeepay.g3.sdk.yop.http.HttpUtils;
import com.yeepay.g3.sdk.yop.http.YopHttpClient;
import com.yeepay.g3.sdk.yop.http.handler.HttpResponseHandler;
import com.yeepay.g3.sdk.yop.internal.InternalRequest;
import com.yeepay.g3.sdk.yop.internal.RestartableInputStream;
import com.yeepay.g3.sdk.yop.model.AbstractYopRequest;
import com.yeepay.g3.sdk.yop.model.AbstractYopResponse;
import com.yeepay.g3.sdk.yop.utils.DateUtils;
import com.yeepay.g3.sdk.yop.utils.JsonUtils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.http.annotation.ThreadSafe;

@ThreadSafe
public abstract class AbstractYopClient {
    public static final String DEFAULT_SERVICE_DOMAIN = "api.yeepay.com";
    public static final String URL_PREFIX = "yop-center";
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String DEFAULT_CONTENT_TYPE = "application/json; charset=utf-8";
    private String serviceId;
    private URI endpoint;
    private YopHttpClient client;
    protected YopClientConfiguration config;
    private HttpResponseHandler[] responseHandlers;

    public AbstractYopClient(String serviceId, YopClientConfiguration config, HttpResponseHandler[] responseHandlers, boolean isHttpAsyncPutEnabled) {
        this.serviceId = serviceId;
        this.config = config;
        this.endpoint = this.computeEndpoint();
        this.client = new YopHttpClient(config, new YopV2Signer(), isHttpAsyncPutEnabled);
        this.responseHandlers = responseHandlers;
    }

    public AbstractYopClient(String serviceId, YopClientConfiguration config, HttpResponseHandler[] responseHandlers) {
        this(serviceId, config, responseHandlers, false);
    }

    public boolean isRegionSupported() {
        return false;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public YopHttpClient getClient() {
        return this.client;
    }

    public void setClient(YopHttpClient client) {
        this.client = client;
    }

    public void shutdown() {
        this.client.shutdown();
    }

    protected InternalRequest createRequest(String resourceKey, AbstractYopRequest yopRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> pathComponents = new ArrayList<String>();
        pathComponents.add(URL_PREFIX);
        this.assertStringNotNullOrEmpty(resourceKey, "String resourceKey should not be null or empty");
        pathComponents.add(resourceKey);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                pathComponents.add(pathVariable);
            }
        }
        InternalRequest internalRequest = new InternalRequest(httpMethod, HttpUtils.appendUri(this.getEndpoint(), pathComponents.toArray(new String[pathComponents.size()])));
        internalRequest.setCredentials(yopRequest.getRequestCredentials());
        YopSignOptions options = YopSignOptions.DEFAULT_SIGN_OPTIONS;
        HashSet<String> headersToSign = new HashSet<String>();
        headersToSign.add("host");
        headersToSign.add("x-yop-date");
        headersToSign.add("x-yop-request-id");
        options.setHeadersToSign(headersToSign);
        new YopV2Signer().sign(internalRequest, internalRequest.getCredentials(), options);
        if (httpMethod == HttpMethodName.POST || httpMethod == HttpMethodName.PUT) {
            this.fillRequestPayload(internalRequest, yopRequest);
        }
        return internalRequest;
    }

    protected InternalRequest fillRequestPayload(InternalRequest internalRequest, AbstractYopRequest yopRequest) {
        byte[] requestJson;
        String strJson = JsonUtils.toJsonString(yopRequest);
        try {
            requestJson = strJson.getBytes(DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new YopClientException("Unsupported encode.", e);
        }
        internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
        internalRequest.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        return internalRequest;
    }

    protected <T extends AbstractYopResponse> T invokeHttpClient(InternalRequest request, Class<T> responseClass) {
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        if (!request.getHeaders().containsKey("Date")) {
            request.addHeader("Date", DateUtils.formatRfc822Date(new Date()));
        }
        return this.client.execute(request, responseClass, this.responseHandlers);
    }

    private URI computeEndpoint() {
        String endpoint = this.config.getEndpoint();
        try {
            if (endpoint == null) {
                String servicePrefix = StringUtils.isBlank((String)this.serviceId) ? "" : this.serviceId + ".";
                String port = 0 == this.config.getPort() ? "" : ":" + this.config.getPort();
                endpoint = this.isRegionSupported() ? String.format("%s://%s%s.%s%S", new Object[]{this.config.getProtocol(), servicePrefix, this.config.getRegion(), DEFAULT_SERVICE_DOMAIN, port}) : String.format("%s://%s%s%s", new Object[]{this.config.getProtocol(), servicePrefix, DEFAULT_SERVICE_DOMAIN, port});
            }
            return new URI(endpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid endpoint." + endpoint, e);
        }
    }

    protected void assertStringNotNullOrEmpty(String parameterValue, String errorMessage) {
        if (parameterValue == null) {
            throw new IllegalArgumentException(errorMessage);
        }
        if (parameterValue.isEmpty() || parameterValue.trim().isEmpty()) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    protected void assertStringArrayNotNullOrEmpty(String[] parameterValue, String errorMessage) {
        if (parameterValue == null) {
            throw new IllegalArgumentException(errorMessage);
        }
        if (parameterValue.length <= 0) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    protected void assertListNotNullOrEmpty(List<?> parameterValue, String errorMessage) {
        if (parameterValue == null) {
            throw new IllegalArgumentException(errorMessage);
        }
        if (parameterValue.size() <= 0) {
            throw new IllegalArgumentException(errorMessage);
        }
    }
}

