/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;

public enum Region {
    CN_N1("sj"),
    CN_N2("dj");

    private List<String> regionIds;

    private Region(String ... regionIds) {
        Preconditions.checkNotNull((Object)regionIds, (Object)"regionIds should not be null.");
        Preconditions.checkArgument((regionIds.length > 0 ? 1 : 0) != 0, (Object)"regionIds should not be empty");
        this.regionIds = Arrays.asList(regionIds);
    }

    public String toString() {
        return this.regionIds.get(0);
    }

    public static Region fromValue(String regionId) {
        Preconditions.checkNotNull((Object)regionId, (Object)"regionId should not be null.");
        for (Region region : Region.values()) {
            List<String> regionIds = region.regionIds;
            if (regionIds == null || !regionIds.contains(regionId)) continue;
            return region;
        }
        throw new IllegalArgumentException("Cannot create region from " + regionId);
    }
}

