/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.yeepay.g3.sdk.yop.Region;
import com.yeepay.g3.sdk.yop.auth.YopCredentials;
import com.yeepay.g3.sdk.yop.http.Protocol;
import com.yeepay.g3.sdk.yop.http.retry.DefaultRetryPolicy;
import com.yeepay.g3.sdk.yop.http.retry.RetryPolicy;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.http.annotation.NotThreadSafe;

@NotThreadSafe
public class YopClientConfiguration {
    public static final int DEFAULT_CONNECTION_TIMEOUT_IN_MILLIS = 50000;
    public static final int DEFAULT_SOCKET_TIMEOUT_IN_MILLIS = 50000;
    public static final int DEFAULT_MAX_CONNECTIONS = 50;
    public static final String DEFAULT_USER_AGENT;
    public static final DefaultRetryPolicy DEFAULT_RETRY_POLICY;
    public static final Region DEFAULT_REGION;
    public static Protocol DEFAULT_PROTOCOL;
    private String userAgent = DEFAULT_USER_AGENT;
    private RetryPolicy retryPolicy = DEFAULT_RETRY_POLICY;
    private InetAddress localAddress;
    private Protocol protocol = Protocol.HTTP;
    private int port;
    private int maxConnections = 50;
    private int socketTimeoutInMillis = 50000;
    private int connectionTimeoutInMillis = 50000;
    private int socketBufferSizeInBytes = 0;
    private String endpoint = null;
    private Region region = DEFAULT_REGION;
    private YopCredentials credentials = null;
    private String proxyHost = null;
    private int proxyPort = -1;
    private String proxyUsername = null;
    private String proxyPassword = null;
    private String proxyDomain = null;
    private String proxyWorkstation = null;
    private boolean proxyPreemptiveAuthenticationEnabled;

    public YopClientConfiguration() {
    }

    public YopClientConfiguration(YopClientConfiguration other) {
        this.connectionTimeoutInMillis = other.connectionTimeoutInMillis;
        this.maxConnections = other.maxConnections;
        this.retryPolicy = other.retryPolicy;
        this.localAddress = other.localAddress;
        this.protocol = other.protocol;
        this.port = other.port;
        this.socketTimeoutInMillis = other.socketTimeoutInMillis;
        this.userAgent = other.userAgent;
        this.socketBufferSizeInBytes = other.socketBufferSizeInBytes;
        this.endpoint = other.endpoint;
        this.region = other.region;
        this.credentials = other.credentials;
        this.proxyDomain = other.proxyDomain;
        this.proxyHost = other.proxyHost;
        this.proxyPassword = other.proxyPassword;
        this.proxyPort = other.proxyPort;
        this.proxyUsername = other.proxyUsername;
        this.proxyWorkstation = other.proxyWorkstation;
        this.proxyPreemptiveAuthenticationEnabled = other.proxyPreemptiveAuthenticationEnabled;
    }

    public YopClientConfiguration(YopClientConfiguration other, String endpoint) {
        this(other);
        this.endpoint = endpoint;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent == null ? DEFAULT_USER_AGENT : (userAgent.endsWith(DEFAULT_USER_AGENT) ? userAgent : userAgent + ", " + DEFAULT_USER_AGENT);
    }

    public YopClientConfiguration withUserAgent(String userAgent) {
        this.setUserAgent(userAgent);
        return this;
    }

    public InetAddress getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(InetAddress localAddress) {
        this.localAddress = localAddress;
    }

    public YopClientConfiguration withLocalAddress(InetAddress localAddress) {
        this.setLocalAddress(localAddress);
        return this;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = null == protocol ? DEFAULT_PROTOCOL : protocol;
    }

    public YopClientConfiguration withProtocol(Protocol protocol) {
        this.setProtocol(protocol);
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public YopClientConfiguration withPort(int port) {
        this.setPort(port);
        return this;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        Preconditions.checkArgument((maxConnections >= 0 ? 1 : 0) != 0, (Object)"maxConnections should not be negative.");
        this.maxConnections = maxConnections;
    }

    public YopClientConfiguration withMaxConnections(int maxConnections) {
        this.setMaxConnections(maxConnections);
        return this;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = null == retryPolicy ? DEFAULT_RETRY_POLICY : retryPolicy;
    }

    public YopClientConfiguration withRetryPolicy(RetryPolicy retryPolicy) {
        this.setRetryPolicy(retryPolicy);
        return this;
    }

    public int getSocketTimeoutInMillis() {
        return this.socketTimeoutInMillis;
    }

    public void setSocketTimeoutInMillis(int socketTimeoutInMillis) {
        Preconditions.checkArgument((socketTimeoutInMillis >= 0 ? 1 : 0) != 0, (Object)"socketTimeoutInMillis should not be negative.");
        this.socketTimeoutInMillis = socketTimeoutInMillis;
    }

    public YopClientConfiguration withSocketTimeoutInMillis(int socketTimeoutInMillis) {
        this.setSocketTimeoutInMillis(socketTimeoutInMillis);
        return this;
    }

    public int getConnectionTimeoutInMillis() {
        return this.connectionTimeoutInMillis;
    }

    public void setConnectionTimeoutInMillis(int connectionTimeoutInMillis) {
        Preconditions.checkArgument((connectionTimeoutInMillis >= 0 ? 1 : 0) != 0, (Object)"connectionTimeoutInMillis should not be negative.");
        this.connectionTimeoutInMillis = connectionTimeoutInMillis;
    }

    public YopClientConfiguration withConnectionTimeoutInMillis(int connectionTimeoutInMillis) {
        this.setConnectionTimeoutInMillis(connectionTimeoutInMillis);
        return this;
    }

    public int getSocketBufferSizeInBytes() {
        return this.socketBufferSizeInBytes;
    }

    public void setSocketBufferSizeInBytes(int socketBufferSizeInBytes) {
        this.socketBufferSizeInBytes = socketBufferSizeInBytes;
    }

    public YopClientConfiguration withSocketBufferSizeInBytes(int socketBufferSizeInBytes) {
        this.setSocketBufferSizeInBytes(socketBufferSizeInBytes);
        return this;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        Preconditions.checkNotNull((Object)endpoint, (Object)"endpoint should not be null.");
        try {
            new URL(endpoint);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid endpoint.", e);
        }
        this.endpoint = endpoint;
    }

    public YopClientConfiguration withEndpoint(String endpoint) {
        this.setEndpoint(endpoint);
        return this;
    }

    public Region getRegion() {
        return this.region;
    }

    public void setRegion(Region region) {
        this.region = null == region ? DEFAULT_REGION : region;
    }

    public YopClientConfiguration withRegion(Region region) {
        this.setRegion(region);
        return this;
    }

    public YopCredentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(YopCredentials credentials) {
        Preconditions.checkNotNull((Object)credentials, (Object)"credentials should not be null.");
        this.credentials = credentials;
    }

    public YopClientConfiguration withCredentials(YopCredentials credentials) {
        this.setCredentials(credentials);
        return this;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public YopClientConfiguration withProxyHost(String proxyHost) {
        this.setProxyHost(proxyHost);
        return this;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public YopClientConfiguration withProxyPort(int proxyPort) {
        this.setProxyPort(proxyPort);
        return this;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public YopClientConfiguration withProxyUsername(String proxyUsername) {
        this.setProxyUsername(proxyUsername);
        return this;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public YopClientConfiguration withProxyPassword(String proxyPassword) {
        this.setProxyPassword(proxyPassword);
        return this;
    }

    public String getProxyDomain() {
        return this.proxyDomain;
    }

    public void setProxyDomain(String proxyDomain) {
        this.proxyDomain = proxyDomain;
    }

    public YopClientConfiguration withProxyDomain(String proxyDomain) {
        this.setProxyDomain(proxyDomain);
        return this;
    }

    public String getProxyWorkstation() {
        return this.proxyWorkstation;
    }

    public void setProxyWorkstation(String proxyWorkstation) {
        this.proxyWorkstation = proxyWorkstation;
    }

    public YopClientConfiguration withProxyWorkstation(String proxyWorkstation) {
        this.setProxyWorkstation(proxyWorkstation);
        return this;
    }

    public boolean isProxyPreemptiveAuthenticationEnabled() {
        return this.proxyPreemptiveAuthenticationEnabled;
    }

    public void setProxyPreemptiveAuthenticationEnabled(boolean proxyPreemptiveAuthenticationEnabled) {
        this.proxyPreemptiveAuthenticationEnabled = proxyPreemptiveAuthenticationEnabled;
    }

    public YopClientConfiguration withProxyPreemptiveAuthenticationEnabled(boolean proxyPreemptiveAuthenticationEnabled) {
        this.setProxyPreemptiveAuthenticationEnabled(proxyPreemptiveAuthenticationEnabled);
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    static {
        String region;
        DEFAULT_RETRY_POLICY = new DefaultRetryPolicy();
        DEFAULT_REGION = Region.CN_N1;
        DEFAULT_PROTOCOL = Protocol.HTTP;
        String language = System.getProperty("user.language");
        if (language == null) {
            language = "";
        }
        if ((region = System.getProperty("user.region")) == null) {
            region = "";
        }
        DEFAULT_USER_AGENT = Joiner.on((char)'/').join((Object)"yop-sdk-java", (Object)"2.0.0", new Object[]{System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("java.vm.name"), System.getProperty("java.vm.version"), System.getProperty("java.version"), language, region}).replace(' ', '_');
    }
}

