/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.auth;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yeepay.g3.sdk.yop.auth.YopCredentials;
import com.yeepay.g3.sdk.yop.auth.YopSessionCredentials;
import com.yeepay.g3.sdk.yop.auth.YopSignOptions;
import com.yeepay.g3.sdk.yop.auth.YopSigner;
import com.yeepay.g3.sdk.yop.encrypt.Digest;
import com.yeepay.g3.sdk.yop.http.HttpUtils;
import com.yeepay.g3.sdk.yop.internal.InternalRequest;
import com.yeepay.g3.sdk.yop.utils.DateUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class YopV2Signer
implements YopSigner {
    private static final Logger LOGGER = Logger.getLogger(YopV2Signer.class);
    private static final String YOP_AUTH_VERSION = "yop-auth-v2";
    private static final Set<String> defaultHeadersToSign = Sets.newHashSet();
    private static final Joiner headerJoiner = Joiner.on((char)'\n');
    private static final Joiner signedHeaderStringJoiner = Joiner.on((char)';');

    @Override
    public void sign(InternalRequest request, YopCredentials credentials) {
        this.sign(request, credentials, null);
    }

    @Override
    public void sign(InternalRequest request, YopCredentials credentials, YopSignOptions options) {
        Date timestamp;
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        if (credentials == null) {
            return;
        }
        if (options == null) {
            options = request.getSignOptions() != null ? request.getSignOptions() : YopSignOptions.DEFAULT_SIGN_OPTIONS;
        }
        String accessKeyId = credentials.getAccessKeyId();
        String secretAccessKey = credentials.getSecretKey();
        request.addHeader("Host", HttpUtils.generateHostHeader(request.getUri()));
        if (credentials instanceof YopSessionCredentials) {
            request.addHeader("x-yop-secure-token", ((YopSessionCredentials)((Object)credentials)).getSessionToken());
        }
        if ((timestamp = options.getTimestamp()) == null) {
            timestamp = new Date();
        }
        String authorizationHeader = this.sign(YOP_AUTH_VERSION, accessKeyId, secretAccessKey, request.getHttpMethod().name(), request.getUri().getPath(), request.getHeaders(), request.getParameterMap(), options.getHeadersToSign(), DateUtils.formatAlternateIso8601Date(timestamp), options.getExpirationInSeconds());
        request.addHeader("Authorization", authorizationHeader);
    }

    public String sign(String version, String accessKeyId, String secretAccessKey, String httpMethod, String path, Map<String, String> headers, Map<String, String[]> parameters, Set<String> headersToSignSet, String timestamp, long expirationInSeconds) {
        String authString = version + "/" + accessKeyId + "/" + timestamp + "/" + expirationInSeconds;
        String signingKey = Digest.sha256Hex(secretAccessKey, authString);
        String canonicalURI = HttpUtils.getCanonicalURIPath(path);
        String canonicalQueryString = HttpUtils.getCanonicalQueryString(parameters, true);
        SortedMap<String, String> headersToSign = this.getHeadersToSign(headers, headersToSignSet);
        String canonicalHeader = this.getCanonicalHeaders(headersToSign);
        String signedHeaders = "";
        if (headersToSignSet != null) {
            signedHeaders = signedHeaderStringJoiner.join(headersToSign.keySet());
            signedHeaders = signedHeaders.trim().toLowerCase();
        }
        String canonicalRequest = httpMethod + "\n" + canonicalURI + "\n" + canonicalQueryString + "\n" + canonicalHeader;
        String signature = Digest.sha256Hex(signingKey, canonicalRequest);
        String authorizationHeader = authString + "/" + signedHeaders + "/" + signature;
        LOGGER.debug((Object)("CanonicalRequest:" + canonicalRequest.replace("\n", "[\\n]") + "\tAuthorization:" + authorizationHeader));
        return authorizationHeader;
    }

    private String getCanonicalHeaders(SortedMap<String, String> headers) {
        if (headers.isEmpty()) {
            return "";
        }
        ArrayList headerStrings = Lists.newArrayList();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String key = entry.getKey();
            if (key == null) continue;
            String value = entry.getValue();
            if (value == null) {
                value = "";
            }
            headerStrings.add(HttpUtils.normalize(key.trim().toLowerCase()) + ':' + HttpUtils.normalize(value.trim()));
        }
        Collections.sort(headerStrings);
        return headerJoiner.join((Iterable)headerStrings);
    }

    private SortedMap<String, String> getHeadersToSign(Map<String, String> headers, Set<String> headersToSign) {
        TreeMap ret = Maps.newTreeMap();
        if (headersToSign != null) {
            HashSet tempSet = Sets.newHashSet();
            for (String header : headersToSign) {
                tempSet.add(header.trim().toLowerCase());
            }
            headersToSign = tempSet;
        }
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String key = entry.getKey();
            if (entry.getValue() == null || entry.getValue().isEmpty() || (headersToSign != null || !this.isDefaultHeaderToSign(key)) && (headersToSign == null || !headersToSign.contains(key.toLowerCase()) || "Authorization".equalsIgnoreCase(key))) continue;
            ret.put(key, entry.getValue());
        }
        return ret;
    }

    private boolean isDefaultHeaderToSign(String header) {
        return (header = header.trim().toLowerCase()).startsWith("x-yop-") || defaultHeadersToSign.contains(header);
    }

    static {
        defaultHeadersToSign.add("Host".toLowerCase());
        defaultHeadersToSign.add("Content-Length".toLowerCase());
        defaultHeadersToSign.add("Content-Type".toLowerCase());
        defaultHeadersToSign.add("Content-MD5".toLowerCase());
    }
}

