/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.client;

import com.yeepay.g3.sdk.yop.client.YopConfig;
import com.yeepay.g3.sdk.yop.client.YopConstants;
import com.yeepay.g3.sdk.yop.client.YopRequest;
import com.yeepay.g3.sdk.yop.client.YopResponse;
import com.yeepay.g3.sdk.yop.client.YopRestTemplate;
import com.yeepay.g3.sdk.yop.encrypt.AESEncrypter;
import com.yeepay.g3.sdk.yop.encrypt.BlowfishEncrypter;
import com.yeepay.g3.sdk.yop.encrypt.Digest;
import com.yeepay.g3.sdk.yop.encrypt.YopSignUtils;
import com.yeepay.g3.sdk.yop.enums.FormatType;
import com.yeepay.g3.sdk.yop.enums.HttpMethodType;
import com.yeepay.g3.sdk.yop.unmarshaller.YopMarshallerUtils;
import com.yeepay.g3.sdk.yop.utils.Assert;
import com.yeepay.g3.sdk.yop.utils.JsonUtils;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.core.io.UrlResource;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class YopClient {
    protected static final Logger logger = Logger.getLogger(YopClient.class);
    protected static RestTemplate restTemplate = new YopRestTemplate();
    protected static Map<String, List<String>> uriTemplateCache = new HashMap<String, List<String>>();

    public static YopResponse post(String methodOrUri, YopRequest request) {
        String content = YopClient.postForString(methodOrUri, request);
        YopResponse response = YopMarshallerUtils.unmarshal(content, request.getFormat(), YopResponse.class);
        YopClient.handleResult(request, response, content);
        return response;
    }

    public static YopResponse get(String methodOrUri, YopRequest request) {
        String content = YopClient.getForString(methodOrUri, request);
        YopResponse response = YopMarshallerUtils.unmarshal(content, request.getFormat(), YopResponse.class);
        YopClient.handleResult(request, response, content);
        return response;
    }

    public static YopResponse upload(String methodOrUri, YopRequest request) {
        String content = YopClient.uploadForString(methodOrUri, request);
        YopResponse response = YopMarshallerUtils.unmarshal(content, request.getFormat(), YopResponse.class);
        YopClient.handleResult(request, response, content);
        return response;
    }

    public static String postForString(String methodOrUri, YopRequest request) {
        String serverUrl = YopClient.richRequest(HttpMethodType.POST, methodOrUri, request);
        YopClient.signAndEncrypt(request);
        request.setAbsoluteURL(serverUrl);
        request.encoding();
        String content = (String)YopClient.getRestTemplate(request).postForObject(serverUrl, request.getParams(), String.class, new Object[0]);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("response:\n" + content));
        }
        return content;
    }

    public static String getForString(String methodOrUri, YopRequest request) {
        String serverUrl = YopClient.buildURL(methodOrUri, request);
        request.setAbsoluteURL(serverUrl);
        String content = (String)YopClient.getRestTemplate(request).getForObject(serverUrl, String.class, new Object[0]);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("response:\n" + content));
        }
        return content;
    }

    public static String uploadForString(String methodOrUri, YopRequest request) {
        String serverUrl = YopClient.richRequest(HttpMethodType.POST, methodOrUri, request);
        MultiValueMap<String, String> original = request.getParams();
        LinkedMultiValueMap alternate = new LinkedMultiValueMap();
        List<String> uploadFiles = request.getParam("_file");
        if (null == uploadFiles || uploadFiles.size() == 0) {
            throw new RuntimeException("\u4e0a\u4f20\u6587\u4ef6\u65f6\u53c2\u6570_file\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        for (String uploadFile : uploadFiles) {
            try {
                alternate.add((Object)"_file", (Object)new UrlResource(new URI(uploadFile)));
            }
            catch (Exception e) {
                logger.debug((Object)"_file upload error.", (Throwable)e);
            }
        }
        YopClient.signAndEncrypt(request);
        request.setAbsoluteURL(serverUrl);
        request.encoding();
        for (String key : original.keySet()) {
            alternate.put((Object)key, new ArrayList((Collection)original.get((Object)key)));
        }
        String content = (String)YopClient.getRestTemplate(request).postForObject(serverUrl, (Object)alternate, String.class, new Object[0]);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("response:\n" + content));
        }
        return content;
    }

    private static RestTemplate getRestTemplate(YopRequest request) {
        if (null != request.getConnectTimeout() || null != request.getReadTimeout()) {
            int connectTimeout = null != request.getConnectTimeout() ? request.getConnectTimeout() : YopConfig.getConnectTimeout();
            int readTimeout = null != request.getReadTimeout() ? request.getReadTimeout() : YopConfig.getReadTimeout();
            return new YopRestTemplate(connectTimeout, readTimeout);
        }
        return restTemplate;
    }

    public static void signAndEncrypt(YopRequest request) {
        Assert.notNull(request.getMethod(), "method must be specified");
        Assert.notNull(request.getSecretKey(), "secretKey must be specified");
        String appKey = request.getParamValue("appKey");
        if (StringUtils.isBlank((String)appKey)) {
            appKey = StringUtils.trimToNull((String)request.getParamValue("customerNo"));
        }
        Assert.notNull(appKey, "appKey \u4e0e customerNo \u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        String signValue = YopSignUtils.sign(YopClient.toSimpleMap(request.getParams()), request.getIgnoreSignParams(), request.getSecretKey(), request.getSignAlg());
        request.addParam("sign", signValue);
        if (request.isRest()) {
            request.removeParam("method");
            request.removeParam("v");
        }
        if (request.isEncrypt()) {
            try {
                YopClient.encrypt(request);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected static void encrypt(YopRequest request) throws Exception {
        String encrypt;
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        MultiValueMap<String, String> params = request.getParams();
        ArrayList keys = new ArrayList(params.keySet());
        for (String key : keys) {
            List values;
            if (YopConstants.isProtectedKey(key) || (values = (List)params.remove((Object)key)) == null || values.isEmpty()) continue;
            for (String v : values) {
                if (first) {
                    first = false;
                } else {
                    builder.append("&");
                }
                builder.append(key).append("=").append(URLEncoder.encode(v, "UTF-8"));
            }
        }
        String encryptBody = builder.toString();
        if (StringUtils.isBlank((String)encryptBody)) {
            request.addParam("encrypt", true);
        } else if (StringUtils.isNotBlank((String)request.getParamValue("appKey"))) {
            encrypt = AESEncrypter.encrypt(encryptBody, request.getSecretKey());
            request.addParam("encrypt", encrypt);
        } else {
            encrypt = BlowfishEncrypter.encrypt(encryptBody, request.getSecretKey());
            request.addParam("encrypt", encrypt);
        }
    }

    protected static String decrypt(YopRequest request, String strResult) {
        if (request.isEncrypt() && StringUtils.isNotBlank((String)strResult)) {
            strResult = StringUtils.isNotBlank((String)request.getParamValue("appKey")) ? AESEncrypter.decrypt(strResult, request.getSecretKey()) : BlowfishEncrypter.decrypt(strResult, request.getSecretKey());
        }
        return strResult;
    }

    protected static Map<String, String> toSimpleMap(MultiValueMap<String, String> form) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry entry : form.entrySet()) {
            map.put((String)entry.getKey(), YopClient.listAsString((List)entry.getValue()));
        }
        return map;
    }

    protected static String listAsString(List<String> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        Collections.sort(list);
        return StringUtils.join(list, (String)",");
    }

    protected static String richRequest(HttpMethodType type, String methodOrUri, YopRequest request) {
        Assert.notNull(methodOrUri, "method name or rest uri");
        if (methodOrUri.startsWith(request.getServerRoot())) {
            methodOrUri = methodOrUri.substring(request.getServerRoot().length() + 1);
        }
        boolean isRest = methodOrUri.startsWith("/rest/");
        request.setRest(isRest);
        String serverUrl = request.getServerRoot();
        if (isRest) {
            methodOrUri = YopClient.mergeTplUri(methodOrUri, request);
            serverUrl = serverUrl + methodOrUri;
            String version = StringUtils.substringBetween((String)methodOrUri, (String)"/rest/v", (String)"/");
            if (StringUtils.isNotBlank((String)version)) {
                request.setVersion(version);
            }
        } else {
            serverUrl = serverUrl + "/command?method=" + methodOrUri;
        }
        request.setMethod(methodOrUri);
        return serverUrl;
    }

    protected static void handleResult(YopRequest request, YopResponse response, String content) {
        response.setFormat(request.getFormat());
        String ziped = "";
        if (response.isSuccess()) {
            String strResult = YopClient.getBizResult(content, request.getFormat());
            ziped = strResult.replaceAll("[ \t\n]", "");
            if (StringUtils.isNotBlank((String)strResult) && response.getError() == null) {
                if (request.isEncrypt()) {
                    String decryptResult = YopClient.decrypt(request, strResult.trim());
                    response.setStringResult(decryptResult);
                    response.setResult(decryptResult);
                    ziped = decryptResult.replaceAll("[ \t\n]", "");
                } else {
                    response.setStringResult(strResult);
                }
            }
        }
        if (request.isSignRet() && StringUtils.isNotBlank((String)response.getSign())) {
            String signStr = response.getState() + ziped + response.getTs();
            response.setValidSign(YopSignUtils.isValidResult(signStr, request.getSecretKey(), request.getSignAlg(), response.getSign()));
        } else {
            response.setValidSign(true);
        }
    }

    private static String getBizResult(String content, FormatType format) {
        if (StringUtils.isBlank((String)content)) {
            return content;
        }
        switch (format) {
            case json: {
                String jsonStr = StringUtils.substringAfter((String)content, (String)"\"result\" : ");
                jsonStr = StringUtils.substringBeforeLast((String)jsonStr, (String)"\"ts\"");
                jsonStr = StringUtils.substringBeforeLast((String)jsonStr, (String)",");
                return jsonStr;
            }
        }
        String xmlStr = StringUtils.substringAfter((String)content, (String)"</state>");
        xmlStr = StringUtils.substringBeforeLast((String)xmlStr, (String)"<ts>");
        return xmlStr;
    }

    public static String buildURL(String methodOrUri, YopRequest request) {
        String serverUrl = YopClient.richRequest(HttpMethodType.GET, methodOrUri, request);
        YopClient.signAndEncrypt(request);
        request.encoding();
        serverUrl = serverUrl + (serverUrl.contains("?") ? "&" : "?" + request.toQueryString());
        return serverUrl;
    }

    public static String getSign(String methodOrUri, YopRequest request) {
        YopClient.richRequest(HttpMethodType.GET, methodOrUri, request);
        YopClient.signAndEncrypt(request);
        return request.getParamValue("sign");
    }

    protected static String mergeTplUri(String tplUri, YopRequest request) {
        String uri = tplUri;
        if (tplUri.indexOf("{") < 0) {
            return uri;
        }
        List<String> dynaParamNames = uriTemplateCache.get(tplUri);
        if (dynaParamNames == null) {
            dynaParamNames = new LinkedList<String>();
            Pattern pattern = Pattern.compile("\\{([^\\}]+)\\}");
            Matcher matcher = pattern.matcher(tplUri);
            while (matcher.find()) {
                dynaParamNames.add(matcher.group(1));
            }
            uriTemplateCache.put(tplUri, dynaParamNames);
        }
        for (String dynaParamName : dynaParamNames) {
            String value = request.removeParam(dynaParamName);
            Assert.notNull(value, dynaParamName + " must be specified");
            uri = uri.replace("{" + dynaParamName + "}", value);
        }
        return uri;
    }

    public static String acceptNotificationAsJson(String key, String response) {
        return YopClient.validateAndDecryptNotification(key, response);
    }

    public static Map acceptNotificationAsMap(String key, String response) {
        String s = YopClient.acceptNotificationAsJson(key, response);
        return s == null ? null : JsonUtils.fromJsonString(YopClient.acceptNotificationAsJson(key, response), Map.class);
    }

    private static String validateAndDecryptNotification(String key, String response) {
        String localSignature;
        Map map = JsonUtils.fromJsonString(response, Map.class);
        boolean doEncryption = Boolean.valueOf(map.get("doEncryption").toString());
        boolean doSignature = Boolean.valueOf(map.get("doSignature").toString());
        String encryption = map.get("encryption").toString();
        String signature = map.get("signature").toString();
        String encryptionAlg = map.get("encryptionAlg").toString();
        String signatureAlg = map.get("signatureAlg").toString();
        if (doEncryption) {
            String string = encryption = encryptionAlg.equals("BLOWFISH") ? BlowfishEncrypter.decrypt(encryption, key) : AESEncrypter.decrypt(encryption, key);
        }
        if (doSignature && !(localSignature = Digest.digest(key + encryption + key, signatureAlg)).equals(signature)) {
            return null;
        }
        return encryption;
    }
}

