/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.client;

import com.yeepay.g3.sdk.yop.client.YopConfig;
import com.yeepay.g3.sdk.yop.client.YopConstants;
import com.yeepay.g3.sdk.yop.enums.FormatType;
import com.yeepay.g3.sdk.yop.internal.InternalRequest;
import com.yeepay.g3.sdk.yop.utils.Assert;
import java.lang.reflect.Array;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class YopRequest
extends InternalRequest {
    private Logger logger = Logger.getLogger(this.getClass());
    private FormatType format = FormatType.json;
    private String method;
    private String locale = "zh_CN";
    private String version = "1.0";
    private String signAlg = "SHA1";
    private String customerNo;
    private MultiValueMap<String, String> paramMap = new LinkedMultiValueMap();
    private List<String> ignoreSignParams = Arrays.asList("sign");
    private boolean encrypt = false;
    private boolean signRet = false;
    private Integer connectTimeout = 30000;
    private Integer readTimeout = 60000;
    private transient boolean isRest = true;
    private String appKey = YopConfig.getAppKey();
    private String secretKey = YopConfig.getSecret();
    private String serverRoot = YopConfig.getServerRoot();
    private String absoluteURL;

    public YopRequest() {
        this.paramMap.set((Object)"appKey", (Object)YopConfig.getAppKey());
        this.paramMap.set((Object)"format", (Object)this.format.name());
        this.paramMap.set((Object)"v", (Object)this.version);
        this.paramMap.set((Object)"locale", (Object)this.locale);
        this.paramMap.set((Object)"ts", (Object)String.valueOf(System.currentTimeMillis()));
    }

    public YopRequest(String appKey, String secretKey) {
        this();
        this.appKey = appKey;
        this.secretKey = secretKey;
        this.paramMap.set((Object)"appKey", (Object)appKey);
    }

    public YopRequest(String appKey, String secretKey, String serverRoot) {
        this(appKey, secretKey);
        this.serverRoot = serverRoot;
    }

    public YopRequest addParam(String paramName, Object paramValue) {
        this.addParam(paramName, paramValue, false);
        return this;
    }

    public YopRequest addParam(String paramName, Object paramValue, boolean ignoreSign) {
        Assert.hasText(paramName, "\u53c2\u6570\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        if (paramValue == null || paramValue instanceof String && StringUtils.isBlank((String)((String)paramValue)) || paramValue instanceof Collection && ((Collection)paramValue).isEmpty()) {
            this.logger.warn((Object)("\u53c2\u6570" + paramName + "\u4e3a\u7a7a\uff0c\u5ffd\u7565"));
            return this;
        }
        if (YopConstants.isProtectedKey(paramName)) {
            this.paramMap.set((Object)paramName, (Object)paramValue.toString().trim());
            return this;
        }
        if (paramValue instanceof Collection) {
            for (Object o : (Collection)paramValue) {
                if (o == null) continue;
                this.paramMap.add((Object)paramName, (Object)o.toString().trim());
            }
        } else if (paramValue.getClass().isArray()) {
            int len = Array.getLength(paramValue);
            for (int i = 0; i < len; ++i) {
                Object o = Array.get(paramValue, i);
                if (o == null) continue;
                this.paramMap.add((Object)paramName, (Object)o.toString().trim());
            }
        } else {
            this.paramMap.add((Object)paramName, (Object)paramValue.toString().trim());
        }
        if (ignoreSign) {
            this.ignoreSignParams.add(paramName);
        }
        return this;
    }

    public List<String> getParam(String key) {
        return (List)this.paramMap.get((Object)key);
    }

    public String getParamValue(String key) {
        return StringUtils.join((Collection)((Collection)this.paramMap.get((Object)key)), (String)",");
    }

    public String removeParam(String key) {
        return StringUtils.join((Collection)((Collection)this.paramMap.remove((Object)key)), (String)",");
    }

    public MultiValueMap<String, String> getParams() {
        return this.paramMap;
    }

    public List<String> getIgnoreSignParams() {
        return this.ignoreSignParams;
    }

    public void setFormat(FormatType format) {
        Assert.notNull((Object)format);
        this.format = format;
        this.paramMap.set((Object)"format", (Object)this.format.name());
    }

    public void setLocale(String locale) {
        this.locale = locale;
        this.paramMap.set((Object)"locale", (Object)this.locale);
    }

    public void setVersion(String version) {
        this.version = version;
        this.paramMap.set((Object)"v", (Object)this.version);
    }

    public void setMethod(String method) {
        this.method = method;
        this.paramMap.set((Object)"method", (Object)this.method);
    }

    public String getMethod() {
        return this.method;
    }

    public FormatType getFormat() {
        return this.format;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getVersion() {
        return this.version;
    }

    public String getSignAlg() {
        return this.signAlg;
    }

    public void setSignAlg(String signAlg) {
        this.signAlg = signAlg;
    }

    public String getCustomerNo() {
        return this.customerNo;
    }

    public void setCustomerNo(String customerNo) {
        this.customerNo = customerNo;
        this.paramMap.set((Object)"customerNo", (Object)this.customerNo);
    }

    public boolean isEncrypt() {
        return this.encrypt;
    }

    public void setEncrypt(boolean encrypt) {
        this.encrypt = encrypt;
    }

    public boolean isSignRet() {
        return this.signRet;
    }

    public void setSignRet(boolean signRet) {
        this.signRet = signRet;
        this.paramMap.set((Object)"signRet", (Object)String.valueOf(this.signRet));
    }

    public boolean isRest() {
        return this.isRest;
    }

    public void setRest(boolean isRest) {
        this.isRest = isRest;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setServerRoot(String serverRoot) {
        this.serverRoot = serverRoot;
    }

    public String getServerRoot() {
        if (StringUtils.isBlank((String)this.serverRoot)) {
            this.serverRoot = YopConfig.getServerRoot();
        }
        return this.serverRoot;
    }

    public void encoding() {
        try {
            for (String key : this.paramMap.keySet()) {
                List values = (List)this.paramMap.get((Object)key);
                ArrayList<String> encoded = new ArrayList<String>(values.size());
                for (String value : values) {
                    if (StringUtils.isBlank((String)value)) continue;
                    encoded.add(URLEncoder.encode(value, "UTF-8"));
                }
                values.clear();
                values.addAll(encoded);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getAbsoluteURL() {
        return this.absoluteURL;
    }

    public void setAbsoluteURL(String absoluteURL) {
        this.absoluteURL = absoluteURL;
    }

    public String toQueryString() {
        StringBuilder builder = new StringBuilder();
        for (String key : this.paramMap.keySet()) {
            List values = (List)this.paramMap.get((Object)key);
            for (String value : values) {
                builder.append(builder.length() == 0 ? "" : "&");
                builder.append(key);
                builder.append("=");
                builder.append(value);
            }
        }
        return builder.toString();
    }
}

