/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.encrypt;

import com.yeepay.g3.sdk.yop.encrypt.Base64;
import com.yeepay.g3.sdk.yop.encrypt.Digest;
import java.security.Key;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class BlowfishEncrypter {
    private static final Logger logger = Logger.getLogger(BlowfishEncrypter.class);
    private static String CIPHER_NAME = "Blowfish/CFB8/NoPadding";
    private static String KEY_SPEC_NAME = "Blowfish";
    private static String CHARSET = "UTF-8";
    private static ConcurrentHashMap<String, BlowfishEncrypter> pool = new ConcurrentHashMap();
    private SecretKeySpec secretKeySpec = null;
    private IvParameterSpec ivParameterSpec;

    private BlowfishEncrypter(String key) {
        try {
            String md5Key = Digest.md5Digest(key);
            this.secretKeySpec = new SecretKeySpec(md5Key.substring(0, 16).getBytes(), KEY_SPEC_NAME);
            this.ivParameterSpec = new IvParameterSpec(md5Key.substring(0, 8).getBytes());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public String encrypt(String data) throws Exception {
        Cipher cipher = Cipher.getInstance(CIPHER_NAME);
        cipher.init(1, (Key)this.secretKeySpec, this.ivParameterSpec);
        return new String(Base64.encode(cipher.doFinal(data.getBytes(CHARSET))), CHARSET);
    }

    public String decrypt(String data) throws Exception {
        Cipher cipher = Cipher.getInstance(CIPHER_NAME);
        cipher.init(2, (Key)this.secretKeySpec, this.ivParameterSpec);
        return new String(cipher.doFinal(Base64.decode(data.getBytes(CHARSET))), CHARSET);
    }

    private static BlowfishEncrypter getInstance(String key) {
        BlowfishEncrypter b = pool.get(key);
        if (b != null) {
            return b;
        }
        b = new BlowfishEncrypter(key);
        pool.put(key, b);
        return b;
    }

    public static String encrypt(String data, String key) {
        if (StringUtils.isBlank((String)data) || StringUtils.isBlank((String)key)) {
            return null;
        }
        try {
            return BlowfishEncrypter.getInstance(key).encrypt(data);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static String decrypt(String data, String key) {
        if (StringUtils.isBlank((String)data) || StringUtils.isBlank((String)key)) {
            return null;
        }
        try {
            return BlowfishEncrypter.getInstance(key).decrypt(data);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }
}

