/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.encrypt;

import com.yeepay.g3.sdk.yop.encrypt.Hex;
import com.yeepay.g3.sdk.yop.exception.YopClientException;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Digest {
    private static final String SHA1 = "SHA-1";
    private static final String MD5 = "MD5";

    public static String md5Digest(String input) {
        try {
            byte[] data = input.getBytes("UTF-8");
            MessageDigest md = MessageDigest.getInstance(MD5);
            return Hex.toHex(md.digest(data));
        }
        catch (Exception e) {
            throw new RuntimeException("digest fail!", e);
        }
    }

    public static String sha1Digest(String input) {
        try {
            byte[] data = input.getBytes("UTF-8");
            MessageDigest md = MessageDigest.getInstance("SHA1");
            return Hex.toHex(md.digest(data));
        }
        catch (Exception e) {
            throw new RuntimeException("digest fail!", e);
        }
    }

    public static String sha256Hex(String signingKey, String input) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(signingKey.getBytes("UTF-8"), "HmacSHA256"));
            return new String(Hex.toHex(mac.doFinal(input.getBytes("UTF-8"))));
        }
        catch (Exception e) {
            throw new YopClientException("Fail to generate the signature", e);
        }
    }

    public static byte[] md5(InputStream input) throws IOException {
        return Digest.digest(input, MD5);
    }

    public static byte[] sha1(InputStream input) throws IOException {
        return Digest.digest(input, SHA1);
    }

    private static byte[] digest(InputStream input, String algorithm) throws IOException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
            int bufferLength = 8192;
            byte[] buffer = new byte[bufferLength];
            int read = input.read(buffer, 0, bufferLength);
            while (read > -1) {
                messageDigest.update(buffer, 0, read);
                read = input.read(buffer, 0, bufferLength);
            }
            return messageDigest.digest();
        }
        catch (GeneralSecurityException e) {
            throw new YopClientException("Fail to generate the signature", e);
        }
    }

    public static String digest(String input, String algorithm) {
        try {
            byte[] data = input.getBytes("UTF-8");
            MessageDigest md = MessageDigest.getInstance(algorithm);
            return Hex.toHex(md.digest(data));
        }
        catch (Exception e) {
            throw new RuntimeException("digest fail!", e);
        }
    }
}

