/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.encrypt;

import com.yeepay.g3.sdk.yop.encrypt.Digest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.util.Assert;

public class YopSignUtils {
    private static final Logger logger = Logger.getLogger(YopSignUtils.class);

    public static String sign(Map<String, String> paramValues, String secret) {
        return YopSignUtils.sign(paramValues, null, secret, "SHA");
    }

    public static String sign(Map<String, String> paramValues, String secret, String algName) {
        return YopSignUtils.sign(paramValues, null, secret, algName);
    }

    public static String sign(Map<String, String> paramValues, List<String> ignoreParamNames, String secret, String algName) {
        Assert.notNull(paramValues);
        Assert.notNull((Object)secret);
        if (StringUtils.isBlank((String)algName)) {
            algName = "SHA1";
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<String> paramNames = new ArrayList<String>(paramValues.size());
        paramNames.addAll(paramValues.keySet());
        if (ignoreParamNames != null && ignoreParamNames.size() > 0) {
            for (String ignoreParamName : ignoreParamNames) {
                paramNames.remove(ignoreParamName);
            }
        }
        Collections.sort(paramNames);
        sb.append(secret);
        for (String paramName : paramNames) {
            if (StringUtils.isBlank((String)paramValues.get(paramName))) continue;
            sb.append(paramName).append(paramValues.get(paramName));
        }
        sb.append(secret);
        return Digest.digest(sb.toString(), algName);
    }

    public static boolean isValidResult(String result, String secret, String algName, String sign) {
        Assert.notNull((Object)secret);
        Assert.notNull((Object)sign);
        if (StringUtils.isBlank((String)algName)) {
            algName = "SHA";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(secret);
        sb.append(StringUtils.trimToEmpty((String)result));
        sb.append(secret);
        String newSign = Digest.digest(sb.toString(), algName);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u672c\u5730\u7b7e\u540d\uff1a" + newSign + " | \u670d\u52a1\u7aef\u7b7e\u540d\uff1a" + sign));
        }
        return StringUtils.equalsIgnoreCase((String)sign, (String)newSign);
    }
}

