/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.http;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.yeepay.g3.sdk.yop.http.Protocol;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.log4j.Logger;

public final class HttpUtils {
    private static final Logger LOGGER;
    private static BitSet URI_UNRESERVED_CHARACTERS;
    private static String[] PERCENT_ENCODED_STRINGS;
    private static final Joiner queryStringJoiner;
    private static boolean HTTP_VERBOSE;
    private static final int PORT_LOWER_BOUND = 1;
    private static final int PORT_UPPER_BOUND = 65535;

    private HttpUtils() {
    }

    public static String normalizePath(String path) {
        return HttpUtils.normalize(path).replace("%2F", "/");
    }

    public static String normalize(String value) {
        try {
            StringBuilder builder = new StringBuilder();
            for (byte b : value.getBytes("UTF-8")) {
                int bl = b & 0xFF;
                if (URI_UNRESERVED_CHARACTERS.get(bl)) {
                    builder.append((char)b);
                    continue;
                }
                builder.append(PERCENT_ENCODED_STRINGS[bl]);
            }
            return builder.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String generateHostHeader(URI uri) {
        String host = uri.getHost();
        if (HttpUtils.isUsingNonDefaultPort(uri)) {
            host = host + ":" + uri.getPort();
        }
        return host;
    }

    public static boolean isUsingNonDefaultPort(URI uri) {
        String scheme = uri.getScheme().toLowerCase();
        int port = uri.getPort();
        if (port < 1 || port > 65535) {
            return false;
        }
        if (scheme.equals(Protocol.HTTP.toString())) {
            return port != Protocol.HTTP.getDefaultPort();
        }
        if (scheme.equals(Protocol.HTTPS.toString())) {
            return port != Protocol.HTTPS.getDefaultPort();
        }
        return false;
    }

    public static String getCanonicalURIPath(String path) {
        if (path == null) {
            return "/";
        }
        if (path.startsWith("/")) {
            return HttpUtils.normalizePath(path);
        }
        return "/" + HttpUtils.normalizePath(path);
    }

    public static String getCanonicalQueryString(Map<String, String[]> parameters, boolean forSignature) {
        if (parameters.isEmpty()) {
            return "";
        }
        ArrayList parameterStrings = Lists.newArrayList();
        for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
            String key = entry.getKey();
            Preconditions.checkNotNull((Object)key, (Object)"parameter key should not be null");
            if (forSignature && "Authorization".equalsIgnoreCase(key)) continue;
            String[] value = entry.getValue();
            if (value.length == 0) {
                if (forSignature) {
                    parameterStrings.add(HttpUtils.normalize(key) + '=');
                    continue;
                }
                parameterStrings.add(HttpUtils.normalize(key));
                continue;
            }
            for (String item : value) {
                parameterStrings.add(HttpUtils.normalize(key) + '=' + HttpUtils.normalize(item));
            }
        }
        Collections.sort(parameterStrings);
        return queryStringJoiner.join((Iterable)parameterStrings);
    }

    public static URI appendUri(URI baseUri, String ... pathComponents) {
        StringBuilder builder = new StringBuilder(baseUri.toASCIIString());
        for (String path : pathComponents) {
            if (!StringUtils.isNotEmpty((String)path)) continue;
            if ((path = HttpUtils.normalizePath(path)).startsWith("/")) {
                if (builder.charAt(builder.length() - 1) == '/') {
                    builder.setLength(builder.length() - 1);
                }
            } else if (builder.charAt(builder.length() - 1) != '/') {
                builder.append('/');
            }
            builder.append(path);
        }
        try {
            return new URI(builder.toString());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unexpected error", e);
        }
    }

    public static void printRequest(HttpRequestBase request) {
        if (!HTTP_VERBOSE) {
            return;
        }
        LOGGER.debug((Object)"\n-------------> ");
        LOGGER.debug((Object)request.getRequestLine());
        for (Header h : request.getAllHeaders()) {
            LOGGER.debug((Object)(h.getName() + " : " + h.getValue()));
        }
        RequestConfig config = request.getConfig();
        if (config != null) {
            LOGGER.debug((Object)("getConnectionRequestTimeout: " + config.getConnectionRequestTimeout()));
            LOGGER.debug((Object)("getConnectTimeout: " + config.getConnectTimeout()));
            LOGGER.debug((Object)("getCookieSpec: " + config.getCookieSpec()));
            LOGGER.debug((Object)("getLocalAddress: " + config.getLocalAddress()));
        }
    }

    public static void printResponse(CloseableHttpResponse response) {
        Header[] heads;
        if (!HTTP_VERBOSE) {
            return;
        }
        LOGGER.debug((Object)"\n<------------- ");
        StatusLine status = response.getStatusLine();
        LOGGER.debug((Object)(status.getStatusCode() + " - " + status.getReasonPhrase()));
        for (Header h : heads = response.getAllHeaders()) {
            LOGGER.debug((Object)(h.getName() + " : " + h.getValue()));
        }
    }

    static {
        int i;
        LOGGER = Logger.getLogger(HttpUtils.class);
        URI_UNRESERVED_CHARACTERS = new BitSet();
        PERCENT_ENCODED_STRINGS = new String[256];
        queryStringJoiner = Joiner.on((char)'&');
        HTTP_VERBOSE = Boolean.parseBoolean(System.getProperty("yop.sdk.http", "false"));
        for (i = 97; i <= 122; ++i) {
            URI_UNRESERVED_CHARACTERS.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            URI_UNRESERVED_CHARACTERS.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            URI_UNRESERVED_CHARACTERS.set(i);
        }
        URI_UNRESERVED_CHARACTERS.set(45);
        URI_UNRESERVED_CHARACTERS.set(46);
        URI_UNRESERVED_CHARACTERS.set(95);
        URI_UNRESERVED_CHARACTERS.set(126);
        for (i = 0; i < PERCENT_ENCODED_STRINGS.length; ++i) {
            HttpUtils.PERCENT_ENCODED_STRINGS[i] = String.format("%%%02X", i);
        }
    }
}

