/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.http;

import com.google.common.base.Preconditions;
import com.yeepay.g3.sdk.yop.YopClientConfiguration;
import com.yeepay.g3.sdk.yop.auth.YopCredentials;
import com.yeepay.g3.sdk.yop.auth.YopSigner;
import com.yeepay.g3.sdk.yop.exception.YopClientException;
import com.yeepay.g3.sdk.yop.http.HttpMethodName;
import com.yeepay.g3.sdk.yop.http.HttpUtils;
import com.yeepay.g3.sdk.yop.http.IdleConnectionReaper;
import com.yeepay.g3.sdk.yop.http.Protocol;
import com.yeepay.g3.sdk.yop.http.YopCloseableHttpResponse;
import com.yeepay.g3.sdk.yop.http.YopHttpResponse;
import com.yeepay.g3.sdk.yop.http.handler.HttpResponseHandler;
import com.yeepay.g3.sdk.yop.http.retry.RetryPolicy;
import com.yeepay.g3.sdk.yop.internal.InternalRequest;
import com.yeepay.g3.sdk.yop.model.AbstractYopResponse;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.Future;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.client.methods.HttpAsyncMethods;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.protocol.BasicAsyncResponseConsumer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.protocol.HttpContext;
import org.apache.log4j.Logger;

@ThreadSafe
public class YopHttpClient {
    private static final Logger LOGGER = Logger.getLogger(YopHttpClient.class);
    private static final Logger requestLogger = Logger.getLogger((String)"com.yeepay.yop.request");
    protected CloseableHttpClient httpClient;
    protected YopClientConfiguration config;
    protected YopSigner signer;
    private HttpClientConnectionManager connectionManager;
    private RequestConfig.Builder requestConfigBuilder;
    private CredentialsProvider credentialsProvider;
    private HttpHost proxyHttpHost;
    private boolean isHttpAsyncPutEnabled = false;

    public YopHttpClient(YopClientConfiguration config, YopSigner signer) {
        Preconditions.checkNotNull((Object)config, (Object)"config should not be null.");
        Preconditions.checkNotNull((Object)signer, (Object)"signer should not be null.");
        this.config = config;
        this.signer = signer;
        this.connectionManager = this.createHttpClientConnectionManager();
        this.httpClient = this.createHttpClient(this.connectionManager);
        IdleConnectionReaper.registerConnectionManager(this.connectionManager);
        this.requestConfigBuilder = RequestConfig.custom();
        this.requestConfigBuilder.setConnectTimeout(config.getConnectionTimeoutInMillis());
        this.requestConfigBuilder.setStaleConnectionCheckEnabled(true);
        if (config.getLocalAddress() != null) {
            this.requestConfigBuilder.setLocalAddress(config.getLocalAddress());
        }
        String proxyHost = config.getProxyHost();
        int proxyPort = config.getProxyPort();
        if (proxyHost != null && proxyPort > 0) {
            this.proxyHttpHost = new HttpHost(proxyHost, proxyPort);
            this.requestConfigBuilder.setProxy(this.proxyHttpHost);
            this.credentialsProvider = new BasicCredentialsProvider();
            String proxyUsername = config.getProxyUsername();
            String proxyPassword = config.getProxyPassword();
            String proxyDomain = config.getProxyDomain();
            String proxyWorkstation = config.getProxyWorkstation();
            if (proxyUsername != null && proxyPassword != null) {
                this.credentialsProvider.setCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new NTCredentials(proxyUsername, proxyPassword, proxyWorkstation, proxyDomain));
            }
        }
    }

    public YopHttpClient(YopClientConfiguration config, YopSigner signer, boolean isHttpAsyncPutEnabled) {
        this(config, signer);
        this.isHttpAsyncPutEnabled = isHttpAsyncPutEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends AbstractYopResponse> T execute(InternalRequest request, Class<T> responseClass, HttpResponseHandler[] responseHandlers) {
        request.addHeader("User-Agent", this.config.getUserAgent());
        YopCredentials credentials = this.config.getCredentials();
        if (request.getCredentials() != null) {
            credentials = request.getCredentials();
        }
        long delayForNextRetryInMillis = 0L;
        int attempt = 1;
        while (true) {
            block28: {
                HttpRequestBase httpRequest = null;
                CloseableHttpResponse httpResponse = null;
                CloseableHttpAsyncClient httpAsyncClient = null;
                try {
                    if (credentials != null) {
                        this.signer.sign(request, credentials);
                    }
                    requestLogger.debug((Object)("Sending Request: " + request));
                    httpRequest = this.createHttpRequest(request);
                    HttpClientContext httpContext = this.createHttpContext(request);
                    if (this.isHttpAsyncPutEnabled && httpRequest.getMethod().equals("PUT")) {
                        httpAsyncClient = this.createHttpAsyncClient(this.createNHttpClientConnectionManager());
                        httpAsyncClient.start();
                        Future future = httpAsyncClient.execute(HttpAsyncMethods.create((HttpUriRequest)httpRequest), (HttpAsyncResponseConsumer)new BasicAsyncResponseConsumer(), (HttpContext)httpContext, null);
                        httpResponse = new YopCloseableHttpResponse((HttpResponse)future.get());
                    } else {
                        httpResponse = this.httpClient.execute((HttpUriRequest)httpRequest, (HttpContext)httpContext);
                    }
                    HttpUtils.printRequest(httpRequest);
                    YopHttpResponse yopHttpResponse = new YopHttpResponse(httpResponse);
                    AbstractYopResponse response = (AbstractYopResponse)responseClass.newInstance();
                    for (HttpResponseHandler handler : responseHandlers) {
                        if (handler.handle(yopHttpResponse, response)) break;
                    }
                    AbstractYopResponse abstractYopResponse = response;
                    return (T)abstractYopResponse;
                }
                catch (Exception e) {
                    YopClientException yop;
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info((Object)"Unable to execute HTTP request", (Throwable)e);
                    }
                    if ((delayForNextRetryInMillis = this.getDelayBeforeNextRetryInMillis(httpRequest, yop = e instanceof YopClientException ? (YopClientException)e : new YopClientException("Unable to execute HTTP request", e), attempt, this.config.getRetryPolicy())) < 0L) {
                        throw yop;
                    }
                    LOGGER.debug((Object)("Retriable error detected, will retry in " + delayForNextRetryInMillis + " ms, attempt number: " + attempt));
                    try {
                        Thread.sleep(delayForNextRetryInMillis);
                    }
                    catch (InterruptedException e1) {
                        throw new YopClientException("Delay interrupted", e1);
                    }
                    if (request.getContent() != null) {
                        request.getContent().restart();
                    }
                    if (httpResponse == null) break block28;
                    try {
                        InputStream inputStream;
                        HttpEntity entity = httpResponse.getEntity();
                        if (entity != null && entity.isStreaming() && (inputStream = entity.getContent()) != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException e1) {
                        LOGGER.debug((Object)"Fail to consume entity.", (Throwable)e1);
                        try {
                            httpResponse.close();
                        }
                        catch (IOException iOException) {
                            LOGGER.debug((Object)"Fail to close connection.", (Throwable)iOException);
                        }
                    }
                }
                finally {
                    try {
                        if (httpAsyncClient != null) {
                            httpAsyncClient.close();
                        }
                    }
                    catch (IOException e) {
                        LOGGER.debug((Object)"Fail to close HttpAsyncClient", (Throwable)e);
                    }
                }
            }
            ++attempt;
        }
    }

    public void shutdown() {
        IdleConnectionReaper.removeConnectionManager(this.connectionManager);
        this.connectionManager.shutdown();
    }

    protected long getDelayBeforeNextRetryInMillis(HttpRequestBase method, YopClientException exception, int attempt, RetryPolicy retryPolicy) {
        HttpEntity entity;
        int retries = attempt - 1;
        int maxErrorRetry = retryPolicy.getMaxErrorRetry();
        if (retries >= maxErrorRetry) {
            return -1L;
        }
        if (method instanceof HttpEntityEnclosingRequest && (entity = ((HttpEntityEnclosingRequest)method).getEntity()) != null && !entity.isRepeatable()) {
            LOGGER.debug((Object)"Entity not repeatable, stop retrying");
            return -1L;
        }
        return Math.min(retryPolicy.getMaxDelayInMillis(), retryPolicy.getDelayBeforeNextRetryInMillis(exception, retries));
    }

    private HttpClientConnectionManager createHttpClientConnectionManager() {
        SSLConnectionSocketFactory sslSocketFactory;
        PlainConnectionSocketFactory socketFactory = PlainConnectionSocketFactory.getSocketFactory();
        try {
            sslSocketFactory = new SSLConnectionSocketFactory(SSLContext.getDefault(), SSLConnectionSocketFactory.STRICT_HOSTNAME_VERIFIER);
        }
        catch (NoSuchAlgorithmException e) {
            throw new YopClientException("Fail to create SSLConnectionSocketFactory", e);
        }
        Registry registry = RegistryBuilder.create().register(Protocol.HTTP.toString(), (Object)socketFactory).register(Protocol.HTTPS.toString(), (Object)sslSocketFactory).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
        connectionManager.setDefaultMaxPerRoute(this.config.getMaxConnections());
        connectionManager.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(this.config.getSocketTimeoutInMillis()).setTcpNoDelay(true).build());
        connectionManager.setMaxTotal(this.config.getMaxConnections());
        return connectionManager;
    }

    protected NHttpClientConnectionManager createNHttpClientConnectionManager() throws IOReactorException {
        DefaultConnectingIOReactor ioReactor = new DefaultConnectingIOReactor(IOReactorConfig.custom().setSoTimeout(this.config.getSocketTimeoutInMillis()).setTcpNoDelay(true).build());
        PoolingNHttpClientConnectionManager connectionManager = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor);
        connectionManager.setDefaultMaxPerRoute(this.config.getMaxConnections());
        connectionManager.setMaxTotal(this.config.getMaxConnections());
        return connectionManager;
    }

    private CloseableHttpClient createHttpClient(HttpClientConnectionManager connectionManager) {
        HttpClientBuilder builder = HttpClients.custom().setConnectionManager(connectionManager).disableAutomaticRetries();
        int socketBufferSizeInBytes = this.config.getSocketBufferSizeInBytes();
        if (socketBufferSizeInBytes > 0) {
            builder.setDefaultConnectionConfig(ConnectionConfig.custom().setBufferSize(socketBufferSizeInBytes).build());
        }
        return builder.build();
    }

    protected CloseableHttpAsyncClient createHttpAsyncClient(NHttpClientConnectionManager connectionManager) {
        HttpAsyncClientBuilder builder = HttpAsyncClients.custom().setConnectionManager(connectionManager);
        int socketBufferSizeInBytes = this.config.getSocketBufferSizeInBytes();
        if (socketBufferSizeInBytes > 0) {
            builder.setDefaultConnectionConfig(ConnectionConfig.custom().setBufferSize(socketBufferSizeInBytes).build());
        }
        return builder.build();
    }

    protected HttpRequestBase createHttpRequest(InternalRequest request) {
        HttpGet httpRequest;
        String uri = request.getUri().toASCIIString();
        String encodedParams = HttpUtils.getCanonicalQueryString(request.getParameterMap(), false);
        if (encodedParams.length() > 0) {
            uri = uri + "?" + encodedParams;
        }
        long contentLength = -1L;
        String contentLengthString = request.getHeaders().get("Content-Length");
        if (contentLengthString != null) {
            contentLength = Long.parseLong(contentLengthString);
        }
        if (request.getHttpMethod() == HttpMethodName.GET) {
            httpRequest = new HttpGet(uri);
        } else if (request.getHttpMethod() == HttpMethodName.PUT) {
            HttpPut putMethod = new HttpPut(uri);
            httpRequest = putMethod;
            if (request.getContent() != null) {
                putMethod.setEntity((HttpEntity)new InputStreamEntity((InputStream)request.getContent(), contentLength));
            }
        } else if (request.getHttpMethod() == HttpMethodName.POST) {
            HttpPost postMethod = new HttpPost(uri);
            httpRequest = postMethod;
            if (request.getContent() != null) {
                postMethod.setEntity((HttpEntity)new InputStreamEntity((InputStream)request.getContent(), contentLength));
            }
        } else if (request.getHttpMethod() == HttpMethodName.DELETE) {
            httpRequest = new HttpDelete(uri);
        } else if (request.getHttpMethod() == HttpMethodName.HEAD) {
            httpRequest = new HttpHead(uri);
        } else {
            throw new YopClientException("Unknown HTTP method name: " + (Object)((Object)request.getHttpMethod()));
        }
        httpRequest.addHeader("Host", HttpUtils.generateHostHeader(request.getUri()));
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            if (entry.getKey().equalsIgnoreCase("Content-Length") || entry.getKey().equalsIgnoreCase("Host")) continue;
            httpRequest.addHeader(entry.getKey(), entry.getValue());
        }
        Preconditions.checkNotNull((Object)httpRequest.getFirstHeader("Content-Type"), (Object)"Content-Type not set");
        return httpRequest;
    }

    protected HttpClientContext createHttpContext(InternalRequest request) {
        HttpClientContext context = HttpClientContext.create();
        context.setRequestConfig(this.requestConfigBuilder.setExpectContinueEnabled(request.isExpectContinueEnabled()).build());
        if (this.credentialsProvider != null) {
            context.setCredentialsProvider(this.credentialsProvider);
        }
        if (this.config.isProxyPreemptiveAuthenticationEnabled()) {
            BasicAuthCache authCache = new BasicAuthCache();
            authCache.put(this.proxyHttpHost, (AuthScheme)new BasicScheme());
            context.setAuthCache((AuthCache)authCache);
        }
        return context;
    }

    protected void finalize() throws Throwable {
        this.shutdown();
        super.finalize();
    }
}

