/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.http.handler;

import com.yeepay.g3.sdk.yop.YopErrorResponse;
import com.yeepay.g3.sdk.yop.YopServiceException;
import com.yeepay.g3.sdk.yop.http.YopHttpResponse;
import com.yeepay.g3.sdk.yop.http.handler.HttpResponseHandler;
import com.yeepay.g3.sdk.yop.model.AbstractYopResponse;
import com.yeepay.g3.sdk.yop.utils.JsonUtils;
import java.io.InputStream;

public class YopErrorResponseHandler
implements HttpResponseHandler {
    @Override
    public boolean handle(YopHttpResponse httpResponse, AbstractYopResponse response) throws Exception {
        if (httpResponse.getStatusCode() / 100 == 2) {
            return false;
        }
        YopServiceException yse = null;
        InputStream content = httpResponse.getContent();
        if (content != null) {
            YopErrorResponse bceErrorResponse = JsonUtils.loadFrom(content, YopErrorResponse.class);
            if (bceErrorResponse.getMessage() != null) {
                yse = new YopServiceException(bceErrorResponse.getMessage());
                yse.setErrorCode(bceErrorResponse.getCode());
                yse.setRequestId(bceErrorResponse.getRequestId());
            }
            content.close();
        }
        if (yse == null) {
            yse = new YopServiceException(httpResponse.getStatusText());
            yse.setRequestId(response.getMetadata().getYopRequestId());
        }
        yse.setStatusCode(httpResponse.getStatusCode());
        if (yse.getStatusCode() >= 500) {
            yse.setErrorType(YopServiceException.ErrorType.Service);
        } else {
            yse.setErrorType(YopServiceException.ErrorType.Client);
        }
        throw yse;
    }
}

