/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.http.handler;

import com.google.common.base.CharMatcher;
import com.yeepay.g3.sdk.yop.YopResponseMetadata;
import com.yeepay.g3.sdk.yop.http.YopHttpResponse;
import com.yeepay.g3.sdk.yop.http.handler.HttpResponseHandler;
import com.yeepay.g3.sdk.yop.model.AbstractYopResponse;

public class YopMetadataResponseHandler
implements HttpResponseHandler {
    @Override
    public boolean handle(YopHttpResponse httpResponse, AbstractYopResponse response) throws Exception {
        YopResponseMetadata metadata = response.getMetadata();
        metadata.setYopRequestId(httpResponse.getHeader("x-yop-request-id"));
        metadata.setYopContentSha256(httpResponse.getHeader("x-yop-content-sha256"));
        metadata.setContentDisposition(httpResponse.getHeader("Content-Disposition"));
        metadata.setContentEncoding(httpResponse.getHeader("Content-Encoding"));
        metadata.setContentLength(httpResponse.getHeaderAsLong("Content-Length"));
        metadata.setContentMd5(httpResponse.getHeader("Content-MD5"));
        metadata.setContentRange(httpResponse.getHeader("Content-Range"));
        metadata.setContentType(httpResponse.getHeader("Content-Type"));
        metadata.setDate(httpResponse.getHeaderAsRfc822Date("Date"));
        metadata.setTransferEncoding(httpResponse.getHeader("Transfer-Encoding"));
        String eTag = httpResponse.getHeader("ETag");
        if (eTag != null) {
            metadata.setETag(CharMatcher.is((char)'\"').trimFrom((CharSequence)eTag));
        }
        metadata.setExpires(httpResponse.getHeaderAsRfc822Date("Expires"));
        metadata.setLastModified(httpResponse.getHeaderAsRfc822Date("Last-Modified"));
        metadata.setServer(httpResponse.getHeader("Server"));
        return false;
    }
}

