/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.http.retry;

import com.google.common.base.Preconditions;
import com.yeepay.g3.sdk.yop.ErrorCode;
import com.yeepay.g3.sdk.yop.YopServiceException;
import com.yeepay.g3.sdk.yop.exception.YopClientException;
import com.yeepay.g3.sdk.yop.http.retry.RetryPolicy;
import java.io.IOException;
import org.apache.log4j.Logger;

public class DefaultRetryPolicy
implements RetryPolicy {
    private static Logger logger = Logger.getLogger(DefaultRetryPolicy.class);
    protected static final int SCALE_FACTOR = 300;
    private int maxErrorRetry;
    private long maxDelayInMillis;

    public DefaultRetryPolicy() {
        this(3, 20000L);
    }

    public DefaultRetryPolicy(int maxErrorRetry, long maxDelayInMillis) {
        Preconditions.checkArgument((maxErrorRetry >= 0 ? 1 : 0) != 0, (Object)"maxErrorRetry should be a non-negative.");
        Preconditions.checkArgument((maxDelayInMillis >= 0L ? 1 : 0) != 0, (Object)"maxDelayInMillis should be a non-negative.");
        this.maxErrorRetry = maxErrorRetry;
        this.maxDelayInMillis = maxDelayInMillis;
    }

    @Override
    public int getMaxErrorRetry() {
        return this.maxErrorRetry;
    }

    @Override
    public long getMaxDelayInMillis() {
        return this.maxDelayInMillis;
    }

    @Override
    public long getDelayBeforeNextRetryInMillis(YopClientException exception, int retriesAttempted) {
        if (!this.shouldRetry(exception, retriesAttempted)) {
            return -1L;
        }
        if (retriesAttempted < 0) {
            return 0L;
        }
        return this.calDelayBeforeNextRetryInMillis(retriesAttempted);
    }

    protected long calDelayBeforeNextRetryInMillis(int retriesAttempted) {
        return (1 << retriesAttempted + 1) * 300;
    }

    protected boolean shouldRetry(YopClientException exception, int retriesAttempted) {
        if (exception.getCause() instanceof IOException) {
            logger.debug((Object)"Retry for IOException.");
            return true;
        }
        if (exception instanceof YopServiceException) {
            YopServiceException e = (YopServiceException)exception;
            if (e.getStatusCode() == 500) {
                logger.debug((Object)"Retry for internal server error.");
                return true;
            }
            if (e.getStatusCode() == 503) {
                logger.debug((Object)"Retry for service unavailable.");
                return true;
            }
            String errorCode = e.getErrorCode();
            if (ErrorCode.REQUEST_EXPIRED.equals(errorCode)) {
                logger.debug((Object)"Retry for request expired.");
                return true;
            }
        }
        return false;
    }
}

