/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.internal;

import com.google.common.collect.Maps;
import com.yeepay.g3.sdk.yop.auth.YopCredentials;
import com.yeepay.g3.sdk.yop.auth.YopSignOptions;
import com.yeepay.g3.sdk.yop.http.HttpMethodName;
import com.yeepay.g3.sdk.yop.internal.RestartableInputStream;
import com.yeepay.g3.sdk.yop.utils.Assert;
import java.net.URI;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.http.annotation.NotThreadSafe;

@NotThreadSafe
public class InternalRequest {
    protected Map<String, String> headers = Maps.newHashMap();
    protected Map<String, String[]> parameters = Maps.newHashMap();
    protected URI uri;
    protected HttpMethodName httpMethod;
    protected RestartableInputStream content;
    protected YopCredentials credentials;
    protected YopSignOptions signOptions;
    protected boolean expectContinueEnabled;

    protected InternalRequest() {
    }

    public InternalRequest(HttpMethodName httpMethod, URI uri) {
        this.httpMethod = httpMethod;
        this.uri = uri;
    }

    public Map<String, String> addHeader(String name, String value) {
        this.headers.put(name, value);
        return this.headers;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void setParameters(Map<String, String[]> parameters) {
        this.parameters = parameters;
    }

    public void setParameter(String name, String value) {
        this.parameters.put(name, new String[]{value});
    }

    public void setParameter(String name, String[] values) {
        Assert.notNull(name, "Parameter name must not be null");
        this.parameters.put(name, values);
    }

    public void addParameter(String name, String value) {
        this.addParameter(name, new String[]{value});
    }

    public void addParameter(String name, String[] values) {
        Assert.notNull(name, "Parameter name must not be null");
        String[] oldArr = this.parameters.get(name);
        if (oldArr != null) {
            String[] newArr = new String[oldArr.length + values.length];
            System.arraycopy(oldArr, 0, newArr, 0, oldArr.length);
            System.arraycopy(values, 0, newArr, oldArr.length, values.length);
            this.parameters.put(name, newArr);
        } else {
            this.parameters.put(name, values);
        }
    }

    public void removeParameter(String name) {
        org.springframework.util.Assert.notNull((Object)name, (String)"Parameter name must not be null");
        this.parameters.remove(name);
    }

    public void removeAllParameters() {
        this.parameters.clear();
    }

    public String getParameter(String name) {
        String[] arr = name != null ? this.parameters.get(name) : null;
        return arr != null && arr.length > 0 ? arr[0] : null;
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        return name != null ? this.parameters.get(name) : null;
    }

    public Map<String, String[]> getParameterMap() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public URI getUri() {
        return this.uri;
    }

    public HttpMethodName getHttpMethod() {
        return this.httpMethod;
    }

    public RestartableInputStream getContent() {
        return this.content;
    }

    public void setContent(RestartableInputStream content) {
        this.content = content;
    }

    public YopCredentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(YopCredentials credentials) {
        this.credentials = credentials;
    }

    public YopSignOptions getSignOptions() {
        return this.signOptions;
    }

    public void setSignOptions(YopSignOptions signOptions) {
        this.signOptions = signOptions;
    }

    public boolean isExpectContinueEnabled() {
        return this.expectContinueEnabled;
    }

    public void setExpectContinueEnabled(boolean expectContinueEnabled) {
        this.expectContinueEnabled = expectContinueEnabled;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

