/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.unmarshaller;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.yeepay.g3.sdk.yop.unmarshaller.YopMarshaller;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

public class JacksonJsonMarshaller
implements YopMarshaller {
    private static ObjectMapper objectMapper;

    @Override
    public void marshal(Object object, OutputStream outputStream) {
        try {
            JsonGenerator jsonGenerator = this.getObjectMapper().getFactory().createGenerator(outputStream, JsonEncoding.UTF8);
            this.getObjectMapper().writeValue(jsonGenerator, object);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T unmarshal(String content, Class<T> objectType) {
        try {
            return (T)this.getObjectMapper().readValue(content, objectType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ObjectMapper getObjectMapper() throws IOException {
        if (objectMapper == null) {
            objectMapper = new ObjectMapper();
            objectMapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
            objectMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
            objectMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
            objectMapper.setAnnotationIntrospector((AnnotationIntrospector)new JacksonAnnotationIntrospector());
        }
        return objectMapper;
    }
}

