/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.unmarshaller;

import com.fasterxml.jackson.databind.JsonNode;
import com.yeepay.g3.sdk.yop.enums.FormatType;
import com.yeepay.g3.sdk.yop.unmarshaller.JacksonJsonMarshaller;
import com.yeepay.g3.sdk.yop.unmarshaller.JacksonXmlMarshaller;
import com.yeepay.g3.sdk.yop.unmarshaller.YopMarshaller;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class YopMarshallerUtils {
    private static final Logger logger = Logger.getLogger(YopMarshallerUtils.class);
    private static Map<FormatType, YopMarshaller> marshallers = new HashMap<FormatType, YopMarshaller>();

    public static void marshal(FormatType format, Object object, OutputStream outputStream) {
        YopMarshaller marshaller = marshallers.get((Object)format);
        if (marshaller == null) {
            marshaller = marshallers.get((Object)FormatType.json);
        }
        marshaller.marshal(object, outputStream);
    }

    public static <T> T unmarshal(String content, FormatType format, Class<T> objectType) {
        YopMarshaller marshaller = marshallers.get((Object)format);
        if (marshaller == null) {
            marshaller = marshallers.get((Object)FormatType.json);
        }
        return marshaller.unmarshal(content, objectType);
    }

    public static JsonNode parse(String content) {
        try {
            YopMarshaller marshaller = marshallers.get((Object)FormatType.json);
            return marshaller.getObjectMapper().readTree(content);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            return null;
        }
    }

    static {
        marshallers.put(FormatType.json, new JacksonJsonMarshaller());
        marshallers.put(FormatType.xml, new JacksonXmlMarshaller());
    }
}

