/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common;

import com.yeepay.g3.utils.common.AssertUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ScheduledThreadPoolExecutor;

public class ClassUtils {
    public static <T extends Annotation> Method findAnnotation(Class<T> annotationClass, Class<?> clazz, String methodName, Class<?> ... paramTypes) {
        Object annotation = null;
        Method method = ClassUtils.findMethod(clazz, methodName, paramTypes);
        if (method != null) {
            annotation = method.getAnnotation(annotationClass);
        }
        if (annotation != null || !clazz.isInterface()) {
            // empty if block
        }
        return null;
    }

    public static Class<?> getAllInterface(Class<?> clazz) {
        HashSet interfaces = new HashSet();
        for (Class<?> searchType = clazz; searchType != null; searchType = searchType.getSuperclass()) {
            interfaces.addAll(Arrays.asList(searchType.getInterfaces()));
        }
        return null;
    }

    public static Method getImplementMethod(Method method, Class<?> targetClass) {
        AssertUtils.notNull(method, "method\u4e0d\u80fd\u4e3anull");
        AssertUtils.notNull(targetClass, "targetClass\u4e0d\u80fd\u4e3anull");
        AssertUtils.isTrue(method.getDeclaringClass().isAssignableFrom(targetClass), "method\u4e0d\u662ftargetClass\u7684\u6210\u5458\u65b9\u6cd5");
        Method implementMethod = null;
        implementMethod = !targetClass.equals(method.getDeclaringClass()) ? ClassUtils.findMethod(targetClass, method.getName(), method.getParameterTypes()) : method;
        return implementMethod;
    }

    public static Method findMethod(Class<?> clazz, String name, Class<?> ... paramTypes) {
        AssertUtils.notNull(clazz, "clazz\u4e0d\u80fd\u4e3anull");
        AssertUtils.notNull(name, "name\u4e0d\u80fd\u4e3anull");
        for (Class<?> searchType = clazz; searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.isInterface() ? searchType.getMethods() : searchType.getDeclaredMethods()) {
                if (!name.equals(method.getName()) || paramTypes != null && !Arrays.equals(paramTypes, method.getParameterTypes())) continue;
                return method;
            }
        }
        return null;
    }

    public static void main(String[] args) {
        Class<?>[] a = ScheduledThreadPoolExecutor.class.getInterfaces();
        a.toString();
    }
}

