/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common;

import com.yeepay.g3.utils.common.CheckUtils;
import com.yeepay.g3.utils.common.OrderedProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class CommonUtils {
    public static final String SYSPROP_RUNMODE = "runMode";
    public static final String SYSPROP_RUNMODE_TEST = "test";
    public static final String SYSPROP_TESTMODE = "testMode";
    public static final String SYSPROP_TESTMODE_ON = "on";

    public static String getUUID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static Map<String, String> loadProps(String uri) {
        OrderedProperties props = new OrderedProperties();
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(uri);
        try {
            props.loadMap(is, result);
        }
        catch (Exception e) {
            throw new RuntimeException("load resource fail, uri:" + uri + " errorMsg:" + e.getMessage(), e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return result;
    }

    public static void loadProps(String uri, Map map) {
        CheckUtils.notNull(map, "map");
        map.putAll(CommonUtils.loadProps(uri));
    }

    public static List<Map.Entry<String, String>> loadList(String uri) {
        OrderedProperties props = new OrderedProperties();
        ArrayList<Map.Entry<String, String>> list = new ArrayList<Map.Entry<String, String>>();
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(uri);
        try {
            props.loadList(is, list);
        }
        catch (Exception e) {
            throw new RuntimeException("load resource fail, uri:" + uri + " errorMsg:" + e.getMessage(), e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return list;
    }

    public static Object newInstance(String className) {
        try {
            return Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("new instance fail : " + e.getMessage(), e);
        }
    }

    public boolean isTestMode() {
        return SYSPROP_RUNMODE_TEST.equals(System.getProperty(SYSPROP_RUNMODE));
    }

    public boolean isTestMode(String funcName) {
        if (this.isTestMode()) {
            return true;
        }
        return SYSPROP_TESTMODE_ON.equals(System.getProperty("testMode." + funcName));
    }
}

