/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common;

import com.yeepay.g3.utils.common.CheckUtils;
import com.yeepay.g3.utils.common.DateUtils;
import com.yeepay.g3.utils.common.json.JSONUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;

public class ConvertUtils {
    public static Object convert(String toType, String value) {
        Type type = Type.parseType(toType);
        if (type == null) {
            throw new RuntimeException("unsupport type : " + toType);
        }
        return ConvertUtils.convert(type, value);
    }

    public static Object convert(Class toType, String value) {
        Type type;
        if (toType != null && toType.isEnum()) {
            try {
                return Enum.valueOf(toType, value);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((type = Type.parseType(toType)) == null) {
            throw new RuntimeException("unsupport type : " + toType);
        }
        return ConvertUtils.convert(type, value);
    }

    public static Object convert(Type toType, String value) {
        CheckUtils.notNull((Object)toType, "toType");
        if (Type.STRING.equals((Object)toType)) {
            return value;
        }
        if (CheckUtils.isEmpty(value)) {
            return null;
        }
        switch (toType) {
            case INT: {
                return Integer.parseInt(value);
            }
            case LONG: {
                return Long.parseLong(value);
            }
            case BIGINT: {
                return new BigInteger(value);
            }
            case DOUBLE: {
                return Double.parseDouble(value);
            }
            case DATE: {
                try {
                    return DateUtils.parseDate((String)value, (String[])new String[]{DateUtils.DATE_FORMAT_DATEONLY, DateUtils.DATE_FORMAT_DATETIME});
                }
                catch (ParseException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            case SQLDATE: {
                try {
                    return new Date(DateUtils.parseDate(value, DateUtils.DATE_FORMAT_DATEONLY).getTime());
                }
                catch (ParseException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            case TIMESTAMP: {
                try {
                    return new Timestamp(DateUtils.parseDate(value, DateUtils.DATE_FORMAT_DATETIME).getTime());
                }
                catch (ParseException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(value);
            }
            case DECIMAL: {
                return new BigDecimal(value);
            }
            case MAP: {
                return JSONUtils.jsonToMap(value, String.class, String.class);
            }
            case LIST: {
                return JSONUtils.jsonToList(value, String.class);
            }
        }
        throw new RuntimeException("unsupport type : " + (Object)((Object)toType));
    }

    public static enum Type {
        BOOLEAN(new String[]{"boolean", "java.lang.boolean"}),
        STRING(new String[]{"string", "java.lang.string"}),
        INT(new String[]{"int", "integer", "java.lang.integer"}),
        LONG(new String[]{"long", "java.lang.long"}),
        BIGINT(new String[]{"bigint", "biginteger", "java.math.biginteger"}),
        DOUBLE(new String[]{"double", "java.lang.double"}),
        DATE(new String[]{"date", "java.util.date"}),
        SQLDATE(new String[]{"sqldate", "java.sql.date"}),
        TIMESTAMP(new String[]{"timestamp", "java.sql.timestamp"}),
        MAP(new String[]{"map"}),
        LIST(new String[]{"list"}),
        DECIMAL(new String[]{"decimal", "java.math.bigdecimal"});

        private String[] names;

        private Type(String[] names) {
            this.names = names;
        }

        public static Type parseType(String name) {
            if (name != null) {
                name = name.toLowerCase();
            }
            for (Type type : Type.values()) {
                for (String tname : type.names) {
                    if (!tname.equals(name)) continue;
                    return type;
                }
            }
            return null;
        }

        public static Type parseType(Class clz) {
            if (clz == null) {
                return null;
            }
            return Type.parseType(clz.getName());
        }
    }
}

