/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common;

public class DebugUtils {
    public static String getStackTrace(StackTraceElement[] stacks) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < stacks.length; ++i) {
            sb.append("\tat " + stacks[i] + "\n");
        }
        return sb.toString();
    }

    public static String getShortStackTrace(StackTraceElement[] stacks) {
        return DebugUtils.getShortStackTrace(stacks, 10);
    }

    public static String getShortStackTrace(StackTraceElement[] stacks, int topSize) {
        StringBuilder sb = new StringBuilder();
        boolean flag = false;
        for (int i = 0; i < stacks.length; ++i) {
            if (i > topSize) {
                if (stacks[i].getClassName().startsWith("com.yeepay")) {
                    sb.append("\tat " + stacks[i] + "\n");
                    flag = false;
                    continue;
                }
                if (!flag) {
                    sb.append("\t...\n");
                }
                flag = true;
                continue;
            }
            sb.append("\tat " + stacks[i] + "\n");
            flag = false;
        }
        return sb.toString();
    }
}

