/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common;

import com.yeepay.g3.utils.common.httpclient.HttpClientWrapper;
import com.yeepay.g3.utils.common.httpclient.HttpResponseCallBack;
import com.yeepay.g3.utils.common.httpclient.MethodType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;

public class HttpClientUtil
implements HttpClientWrapper {
    private HttpClient client = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
    private Map<String, String> cookies = new HashMap<String, String>();
    List<Header> headers = Collections.synchronizedList(new ArrayList());

    public HttpClientUtil() {
    }

    public HttpClientUtil(String userName, String passWord) {
        this.client.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userName, passWord));
    }

    @Override
    public void clearCookie() {
        this.client.getState().clearCookies();
    }

    private void setCookies(Cookie[] cookies1) {
        for (Cookie cookie : cookies1) {
            this.cookies.put(cookie.getName(), cookie.getValue());
        }
    }

    @Override
    public String doRequest(MethodType method, String url, Map<String, String> params, String charset) throws HttpException, IOException {
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.doRequest(new HttpResponseCallBack(){

            @Override
            public void processResponse(InputStream in) throws IOException {
                int b = -1;
                while ((b = in.read()) != -1) {
                    out.write(b);
                }
                out.flush();
                out.close();
                in.close();
            }
        }, method, url, params, charset);
        return out.toString(charset);
    }

    private void closeConnection(HttpMethod method) {
        method.releaseConnection();
    }

    @Override
    public void doRequest(HttpResponseCallBack callback, MethodType method, String url, Map<String, String> params, String charset) throws HttpException, IOException {
        HttpMethod httpMethod = null;
        switch (method) {
            case GET: {
                httpMethod = this.doGet(url, params, charset);
                break;
            }
            case POST: {
                httpMethod = this.doPost(url, params, charset);
                break;
            }
            case OPTION: {
                httpMethod = this.doOption(url, params, charset);
                break;
            }
            case PUT: {
                httpMethod = this.doPut(url, params, charset);
                break;
            }
            case TRACE: {
                httpMethod = this.doTrace(url, params, charset);
                break;
            }
            case DELETE: {
                httpMethod = this.doDelete(url, params, charset);
                break;
            }
        }
        InputStream is = httpMethod.getResponseBodyAsStream();
        callback.processResponse(is);
        is.close();
        this.closeConnection(httpMethod);
    }

    @Override
    public String doRequest(MethodType method, String url, String charset) throws HttpException, IOException {
        return this.doRequest(method, url, null, charset);
    }

    @Override
    public void doRequest(HttpResponseCallBack callback, MethodType method, String url, String charset) throws HttpException, IOException {
        this.doRequest(callback, method, url, null, charset);
    }

    private List<Header> getHeaders() {
        this.headers.add(new Header("Accept-Language", "zh-CN"));
        this.headers.add(new Header("Accept-Encoding", " gzip, deflate"));
        this.headers.add(new Header("Accept", "image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, application/x-shockwave-flash, application/vnd.ms-excel, application/vnd.ms-powerpoint, application/msword, */*"));
        this.headers.add(new Header("User-Agent", " Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; InfoPath.2)"));
        this.headers.add(new Header("Connection", " Keep-Alive"));
        return this.headers;
    }

    @Override
    public void addHttpHeader(Map<String, String> headers1) {
        this.headers = this.getHeaders();
        Set<String> names = headers1.keySet();
        for (String name : names) {
            for (Header header : this.headers) {
                if (!header.getName().equals(name)) continue;
                header.setValue(headers1.get(name));
            }
            this.headers.add(new Header(name, headers1.get(name)));
        }
    }

    private NameValuePair[] postParams(Map<String, String> params) {
        if (params == null || params.isEmpty()) {
            return new NameValuePair[0];
        }
        Set<String> paramNames = params.keySet();
        int i = 0;
        NameValuePair[] nameValuePairs = new NameValuePair[paramNames.size()];
        for (String paramName : paramNames) {
            NameValuePair nameValuePair;
            nameValuePairs[++i - 1] = nameValuePair = new NameValuePair(paramName, params.get(paramName));
        }
        return nameValuePairs;
    }

    private String createNewUrl(String url, Map<String, String> params) {
        if (params == null || params.isEmpty()) {
            return url;
        }
        Set<String> names = params.keySet();
        int i = 0;
        for (String name : names) {
            String value = params.get(name);
            if (++i == 1) {
                url = url + "?" + name + "=" + value;
                continue;
            }
            url = url + "&" + name + "=" + value;
        }
        return url;
    }

    private String cookieStr(Map<String, String> cookies) {
        if (cookies == null || cookies.isEmpty()) {
            return "";
        }
        String cookieStr = "";
        int i = 0;
        Set<String> cookieNames = cookies.keySet();
        for (String cookie : cookieNames) {
            if (++i == 1) {
                cookieStr = cookieStr + cookie + "=" + cookies.get(cookie);
                continue;
            }
            cookieStr = cookieStr + ";" + cookie + "=" + cookies.get(cookie);
        }
        return cookieStr;
    }

    private HttpMethod doGet(String url, Map<String, String> params, String charset) throws HttpException, IOException {
        String newUrl = this.createNewUrl(url, params);
        GetMethod get = new GetMethod(newUrl);
        get.getParams().setCookiePolicy("compatibility");
        get.setRequestHeader("Cookie", this.cookieStr(this.cookies));
        this.client.getParams().setContentCharset(charset);
        this.client.getHostConfiguration().getParams().setParameter("http.default-headers", this.headers);
        this.executeHttpMethod((HttpMethod)get);
        return get;
    }

    private HttpMethod doPost(String url, Map<String, String> params, String charset) throws HttpException, IOException {
        PostMethod post = new PostMethod(url);
        this.client.getParams().setContentCharset(charset);
        this.client.getHostConfiguration().getParams().setParameter("http.default-headers", this.headers);
        post.setRequestBody(this.postParams(params));
        post.getParams().setCookiePolicy("compatibility");
        post.setRequestHeader("Cookie", this.cookieStr(this.cookies));
        int status = this.executeHttpMethod((HttpMethod)post);
        if (this.isRedirected(status)) {
            Header locationHeader = post.getResponseHeader("location");
            String newUrl = "";
            newUrl = locationHeader != null ? locationHeader.getValue() : "/";
            GetMethod get = new GetMethod(newUrl);
            get.getParams().setCookiePolicy("compatibility");
            get.setRequestHeader("Cookie", this.cookieStr(this.cookies));
            this.executeHttpMethod((HttpMethod)get);
            return get;
        }
        return post;
    }

    private boolean isRedirected(int status) {
        return status == 302 || status == 301 || status == 307 || status == 305 || status == 304 || status == 303;
    }

    private int executeHttpMethod(HttpMethod httpMethod) throws HttpException, IOException {
        int status = this.client.executeMethod(httpMethod);
        this.setCookies(this.client.getState().getCookies());
        return status;
    }

    private HttpMethod doOption(String url, Map<String, String> params, String charset) {
        return null;
    }

    private HttpMethod doDelete(String url, Map<String, String> params, String charset) {
        return null;
    }

    private HttpMethod doPut(String url, Map<String, String> params, String charset) {
        return null;
    }

    private HttpMethod doTrace(String url, Map<String, String> params, String charset) {
        return null;
    }

    @Override
    public void addCookie(Cookie cookie) {
        this.client.getState().addCookie(cookie);
        Cookie[] cookies = this.client.getState().getCookies();
        this.setCookies(cookies);
    }

    @Override
    public void addCookies(Cookie[] cookies1) {
        this.client.getState().addCookies(cookies1);
        Cookie[] cookies = this.client.getState().getCookies();
        this.setCookies(cookies);
    }

    public void setTimeout(int newTimeoutInMilliseconds) {
        this.client.getHttpConnectionManager().getParams().setSoTimeout(newTimeoutInMilliseconds);
    }

    public void setConnectionTimeout(int newTimeoutInMilliseconds) {
        this.client.getHttpConnectionManager().getParams().setConnectionTimeout(newTimeoutInMilliseconds);
    }
}

