/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common;

import com.yeepay.g3.utils.common.CheckUtils;
import com.yeepay.g3.utils.common.CommonUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InitializeUtils {
    private static final Log logger = LogFactory.getLog(InitializeUtils.class);
    private static List<String> destoryList = new ArrayList<String>();

    public static void initComponents() {
        Map<String, String> props = null;
        try {
            props = CommonUtils.loadProps("runtimecfg/initcomponents.properties");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (props == null) {
            props = CommonUtils.loadProps("initcomponents.properties");
        }
        String[] initargs = new String[props.keySet().size()];
        props.keySet().toArray(initargs);
        InitializeUtils.initComponents(initargs);
    }

    public static void registDestoryMethod(String method) {
        destoryList.add(method);
    }

    public static void destoryComponents() {
        if (destoryList.size() > 0) {
            String[] destoryargs = new String[destoryList.size()];
            destoryList.toArray(destoryargs);
            InitializeUtils.initComponents(destoryargs);
        }
    }

    public static void initComponents(String[] args) {
        for (String arg : args) {
            try {
                InitializeUtils.executeInitMethod(arg);
                logger.info((Object)("init component [" + arg + "] success"));
            }
            catch (Throwable e) {
                logger.error((Object)("init component [" + arg + "] error : " + e.getMessage()), e);
                throw new RuntimeException("init component error : " + arg, e);
            }
        }
    }

    private static void executeInitMethod(String arg) throws Throwable {
        CheckUtils.notNull(arg, "");
        int index = arg.lastIndexOf(".");
        if (index <= 0) {
            throw new IllegalArgumentException("invalid init arguments[" + arg + "]");
        }
        String className = arg.substring(0, index);
        String methodName = arg.substring(index + 1, arg.length()).replaceAll("\\(", "").replaceAll("\\)", "");
        Class<?> clz = Class.forName(className);
        Method method = clz.getMethod(methodName, new Class[0]);
        method.invoke(null, new Object[0]);
    }
}

