/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;

public class MathUtils {
    private static final int DEFAULT_DIV_SCALE = 20;
    private static final int BITS = 2;

    public static double add(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.add(b2).doubleValue();
    }

    public static String add(String v1, String v2) {
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.add(b2).toString();
    }

    public static double subtract(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.subtract(b2).doubleValue();
    }

    public static String subtract(String v1, String v2) {
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.subtract(b2).toString();
    }

    public static double multiply(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.multiply(b2).doubleValue();
    }

    public static String multiply(String v1, String v2) {
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.multiply(b2).toString();
    }

    public static double divide(double v1, double v2) {
        return MathUtils.divide(v1, v2, 20);
    }

    public static double divide(double v1, double v2, int scale) {
        return MathUtils.divide(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static double divide(double v1, double v2, int scale, RoundingMode round_mode) {
        if (v2 == 0.0) {
            return 0.0;
        }
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.divide(b2, scale, round_mode).doubleValue();
    }

    public static String divide(String v1, String v2) {
        return MathUtils.divide(v1, v2, 20);
    }

    public static String divide(String v1, String v2, int scale) {
        return MathUtils.divide(v1, v2, 20, RoundingMode.HALF_UP);
    }

    public static String divide(String v1, String v2, int scale, RoundingMode round_mode) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.divide(b2, scale, round_mode).toString();
    }

    public static BigDecimal round(BigDecimal v) {
        return MathUtils.round(v, 2);
    }

    public static BigDecimal round(BigDecimal v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        return MathUtils.round(v, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal round(BigDecimal v, int scale, RoundingMode round_mode) {
        BigDecimal result = v.setScale(scale, round_mode);
        return result;
    }

    public static double round(double v, int scale) {
        return MathUtils.round(v, scale, RoundingMode.HALF_UP);
    }

    public static double round(double v, int scale, RoundingMode round_mode) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b = new BigDecimal(Double.toString(v));
        return b.setScale(scale, round_mode).doubleValue();
    }

    public static String round(String v, int scale) {
        return MathUtils.round(v, scale, RoundingMode.HALF_UP);
    }

    public static String round(String v, int scale, RoundingMode round_mode) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b = new BigDecimal(v);
        return b.setScale(scale, round_mode).toString();
    }

    public static Double add(Double a, Double b) {
        if (a == null && b == null) {
            return null;
        }
        double x = a == null ? 0.0 : a;
        double y = b == null ? 0.0 : b;
        return new Double(MathUtils.add(x, y));
    }

    public static Double subtract(Double a, Double b) {
        if (a == null && b == null) {
            return null;
        }
        double x = a == null ? 0.0 : a;
        double y = b == null ? 0.0 : b;
        return new Double(MathUtils.subtract(x, y));
    }

    public static boolean isPlus(Double d) {
        if (d == null) {
            return false;
        }
        return d > 0.0;
    }

    public static Double multiply(Double a, Double b) {
        if (a == null && b == null) {
            return null;
        }
        double x = a == null ? 0.0 : a;
        double y = b == null ? 0.0 : b;
        return new Double(MathUtils.multiply(x, y));
    }

    public static Double divide(Double a, Double b) {
        double y;
        if (a == null && b == null) {
            return new Double(0.0);
        }
        double x = a == null ? 0.0 : a;
        double d = y = b == null ? 0.0 : b;
        if (x == 0.0 || y == 0.0) {
            return new Double(0.0);
        }
        return new Double(MathUtils.divide(x, y));
    }

    public static Double sum(Double[] values) {
        Double result = new Double(0.0);
        for (int i = 0; i < values.length; ++i) {
            result = MathUtils.add(result, values[i]);
        }
        return result;
    }

    public static Integer add(Integer a, Integer b) {
        int x = a == null ? 0 : a;
        int y = b == null ? 0 : b;
        return new Integer(x + y);
    }

    public static Double reverse(Double a) {
        return MathUtils.subtract(new Double(0.0), a);
    }

    public static String formateDouble(Double a) {
        if (a != null) {
            DecimalFormat form = new DecimalFormat("####0.00");
            return form.format(a);
        }
        return "0.00";
    }

    public static String formateDouble(double a) {
        DecimalFormat form = new DecimalFormat("####0.00");
        return form.format(a);
    }

    public static String formateDoubleRate(Double a) {
        if (a != null) {
            DecimalFormat form = new DecimalFormat("####0.0000");
            return form.format(a);
        }
        return "0.0000";
    }

    public static String formateRate(Double a, int peci) {
        String result = "";
        if (a != null) {
            StringBuffer sb = new StringBuffer("####0.");
            for (int i = 0; i < peci; ++i) {
                sb.append("0");
            }
            DecimalFormat form = new DecimalFormat(sb.toString());
            result = form.format(a);
        }
        return result;
    }

    public static String formateDoubleRate(double a) {
        DecimalFormat form = new DecimalFormat("####0.0000");
        return form.format(a);
    }

    public static Double changeDoubleNull(Double a) {
        return a == null ? new Double(0.0) : a;
    }

    public static void main(String[] args) {
        System.out.println(MathUtils.add("8.5", "3.2"));
        System.out.println(MathUtils.add(8.012, 2.5));
        System.out.println(MathUtils.add(8L, 2L));
        System.out.println(MathUtils.multiply(8.01, 2.01));
        BigDecimal s1 = new BigDecimal(1.234567810124E9);
        BigDecimal s2 = new BigDecimal(12);
        BigDecimal result = s2.subtract(s2);
        result = result.setScale(2, RoundingMode.HALF_UP);
        int c = result.compareTo(BigDecimal.ZERO);
        System.out.println(c);
        System.out.println("result: " + result);
    }

    public static int compare(Double a, Double b) {
        Double diff = MathUtils.subtract(a, b);
        if (diff == null || diff == 0.0) {
            return 0;
        }
        if (diff > 0.0) {
            return 1;
        }
        return -1;
    }

    public static long add(long v1, long v2) {
        BigDecimal b1 = new BigDecimal(Long.toString(v1));
        BigDecimal b2 = new BigDecimal(Long.toString(v2));
        return b1.add(b2).longValue();
    }

    public static Long add(Long v1, Long v2) {
        if (v1 == null && v2 == null) {
            return null;
        }
        long x = v1 == null ? 0L : v1;
        long y = v2 == null ? 0L : v2;
        return new Long(MathUtils.add(x, y));
    }
}

