/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common;

import com.yeepay.g3.utils.common.CheckUtils;
import com.yeepay.g3.utils.common.CommonUtils;
import com.yeepay.g3.utils.common.FormatUtils;
import com.yeepay.g3.utils.common.MaskUtils;
import com.yeepay.g3.utils.common.ValidateUtils;
import com.yeepay.g3.utils.common.log.Logger;
import com.yeepay.g3.utils.common.log.LoggerFactory;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang.StringEscapeUtils;

public class MessageFormater {
    private static Logger logger = LoggerFactory.getLogger(MessageFormater.class);
    public static String DEFAULT_PATTERNMODE_DATE = "datetime";
    public static String DEFAULT_PATTERNMODE_NUMBER = "amount";
    private Map<String, String> patterns;
    private Map<String, Integer> multipliers;
    private RoundingMode roundingMode;

    public MessageFormater() {
        this("properties/messageFormater.properties");
    }

    public MessageFormater(String properties) {
        this.patterns = CommonUtils.loadProps(properties);
        if (this.patterns == null) {
            throw new RuntimeException("init messageFormater fail! no patterns.properties found!");
        }
        try {
            this.roundingMode = RoundingMode.valueOf(this.patterns.get("roundingMode"));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.roundingMode == null) {
            throw new RuntimeException("init messageFormater fail! no roundingMode specified!");
        }
        this.multipliers = new HashMap<String, Integer>();
        for (String key : this.patterns.keySet()) {
            if (!key.endsWith(".multiplier")) continue;
            try {
                Integer m = Integer.parseInt(this.patterns.get(key));
                this.multipliers.put(key.substring(0, key.length() - 11), m);
            }
            catch (Exception e) {
                throw new RuntimeException("init messageFormater fail! parse multiplier fail : " + key + "=" + this.patterns.get(key));
            }
        }
    }

    public String formatDate(Object date) {
        return this.formatDate(date, DEFAULT_PATTERNMODE_DATE, null);
    }

    public String formatDate(Object date, String _patternMode) {
        String pattern = this.patterns.get(_patternMode);
        CheckUtils.notEmpty(pattern, "pattern");
        return this.formatDateWithPattern(date, pattern, null);
    }

    public String formatDate(Object date, String _patternMode, String timeZone) {
        String pattern = this.patterns.get(_patternMode);
        CheckUtils.notEmpty(pattern, "pattern");
        return this.formatDateWithPattern(date, pattern, timeZone);
    }

    public String formatDateWithPattern(Object date, String pattern, String timeZone) {
        TimeZone _timeZone = null;
        if (!CheckUtils.isEmpty(timeZone)) {
            _timeZone = TimeZone.getTimeZone(timeZone);
        }
        try {
            return FormatUtils.formatDate(date, pattern, _timeZone);
        }
        catch (Exception e) {
            logger.warn("formatDate error : " + e.getMessage());
            return null;
        }
    }

    public String formatNumber(Object num) {
        return this.formatNumber(num, DEFAULT_PATTERNMODE_NUMBER);
    }

    public String formatNumber(Object num, String _patternMode) {
        String pattern = this.patterns.get(_patternMode);
        Integer muliter = this.multipliers.get(_patternMode);
        if (muliter == null) {
            muliter = 1;
        }
        return this.formatNumber(num, pattern, this.roundingMode, muliter);
    }

    public String formatNumber(Object num, String _patternMode, String _roundingMode) {
        String pattern = this.patterns.get(_patternMode);
        Integer muliter = this.multipliers.get(_patternMode);
        if (muliter == null) {
            muliter = 1;
        }
        return this.formatNumber(num, pattern, RoundingMode.valueOf(_roundingMode), muliter);
    }

    public String formatNumber(Object num, String pattern, RoundingMode roundingMode, int multiplier) {
        try {
            return FormatUtils.formatNumber(num, pattern, roundingMode, multiplier);
        }
        catch (Exception e) {
            logger.warn("formatNumber error : " + e.getMessage());
            return null;
        }
    }

    public String formateMoney(Object num) {
        return this.formatNumber(num, "money");
    }

    public String formateAmount(Object num) {
        if (num == null) {
            num = BigDecimal.ZERO;
        }
        return this.formatNumber(num, "signAmount");
    }

    public String escapeHtml(String str) {
        return StringEscapeUtils.escapeHtml((String)str);
    }

    public String escapeJavaScript(String str) {
        return StringEscapeUtils.escapeJavaScript((String)str);
    }

    public String escapeXml(String str) {
        return StringEscapeUtils.escapeXml((String)str);
    }

    @Deprecated
    public String formatCellphone(String cellphoneNo) {
        return FormatUtils.formatCellphone(cellphoneNo);
    }

    @Deprecated
    public String formatEmail(String email) {
        return FormatUtils.formatEmail(email);
    }

    public String maskEmail(String email) {
        return FormatUtils.formatEmail(email);
    }

    public String maskCellphone(String cellphoneNo) {
        return FormatUtils.formatCellphone(cellphoneNo);
    }

    public String maskIDCardNo(String idCardNo) {
        if (CheckUtils.isEmpty(idCardNo)) {
            return idCardNo;
        }
        return MaskUtils.maskIDCardNo(idCardNo);
    }

    public String maskBankCardNo(String bankCardNo) {
        if (CheckUtils.isEmpty(bankCardNo)) {
            return bankCardNo;
        }
        return MaskUtils.maskBankCardNo(bankCardNo);
    }

    public String maskLoginName(String loginName) {
        if (CheckUtils.isEmpty(loginName)) {
            return loginName;
        }
        if (ValidateUtils.isEmail(loginName)) {
            return MaskUtils.maskEmail(loginName);
        }
        if (ValidateUtils.isMobile(loginName)) {
            return MaskUtils.maskCellphone(loginName);
        }
        return loginName;
    }
}

