/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class PropertyUtils {
    private static String GET = "get";
    private static String SET = "set";
    private static String IS = "is";
    private static Map descriptorsCache = new HashMap();

    public static boolean setProperty(Object object, String property, Object value) {
        if (property == null || object == null) {
            return false;
        }
        try {
            PropertyDescriptor pd = PropertyUtils.getPropertyDescriptor(object.getClass(), property);
            if (pd == null) {
                return false;
            }
            pd.getWriteMethod().invoke(object, value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Object getProperty(Object object, String property) {
        return PropertyUtils.invokeProperty(object, property);
    }

    private static String createMethodName(String prefix, String propertyName) {
        return prefix + propertyName.toUpperCase().charAt(0) + propertyName.substring(1);
    }

    private static Object invokeProperty(Object obj, String property) {
        if (property == null || property.length() == 0) {
            return null;
        }
        Class<?> cls = obj.getClass();
        Object[] oParams = new Object[]{};
        Class[] cParams = new Class[]{};
        try {
            Method method = cls.getMethod(PropertyUtils.createMethodName(GET, property), cParams);
            return method.invoke(obj, oParams);
        }
        catch (Exception e1) {
            try {
                Method method = cls.getMethod(PropertyUtils.createMethodName(IS, property), cParams);
                return method.invoke(obj, oParams);
            }
            catch (Exception e2) {
                try {
                    Method method = cls.getMethod(property, cParams);
                    return method.invoke(obj, oParams);
                }
                catch (Exception e3) {
                    try {
                        Field field = cls.getField(property);
                        return field.get(obj);
                    }
                    catch (Exception e4) {
                        return null;
                    }
                }
            }
        }
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class beanClass) {
        if (beanClass == null) {
            throw new IllegalArgumentException("No bean class specified");
        }
        PropertyDescriptor[] descriptors = null;
        descriptors = (PropertyDescriptor[])descriptorsCache.get(beanClass);
        if (descriptors != null) {
            return descriptors;
        }
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException e) {
            return new PropertyDescriptor[0];
        }
        descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null) {
            descriptors = new PropertyDescriptor[]{};
        }
        descriptorsCache.put(beanClass, descriptors);
        return descriptors;
    }

    public static PropertyDescriptor getPropertyDescriptor(Class clz, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (name == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        PropertyDescriptor[] descriptors = PropertyUtils.getPropertyDescriptors(clz);
        if (descriptors != null) {
            for (int i = 0; i < descriptors.length; ++i) {
                if (!name.equals(descriptors[i].getName())) continue;
                return descriptors[i];
            }
        }
        return null;
    }

    public static Class getPropertyType(Class clz, String propertyName) {
        PropertyDescriptor desc;
        try {
            desc = PropertyUtils.getPropertyDescriptor(clz, propertyName);
        }
        catch (Exception e) {
            return null;
        }
        if (desc == null) {
            return null;
        }
        return desc.getPropertyType();
    }

    public static Class[] getPropertyGenericActualTypes(Class clz, String propertyName) {
        ParameterizedType pt;
        Type[] types;
        PropertyDescriptor desc;
        try {
            desc = PropertyUtils.getPropertyDescriptor(clz, propertyName);
        }
        catch (Exception e) {
            return null;
        }
        Type type = desc.getReadMethod().getGenericReturnType();
        if (type == null) {
            return null;
        }
        if (type instanceof ParameterizedType && (types = (pt = (ParameterizedType)type).getActualTypeArguments()) != null) {
            Class[] clzs = new Class[types.length];
            for (int i = 0; i < types.length; ++i) {
                clzs[i] = (Class)types[i];
            }
            return clzs;
        }
        return null;
    }

    public static String[] getPropertyNames(Class clz) {
        try {
            PropertyDescriptor[] properties = PropertyUtils.getPropertyDescriptors(clz);
            String[] result = new String[properties.length];
            for (int i = 0; i < properties.length; ++i) {
                result[i] = properties[i].getName();
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void main(String[] args) {
    }
}

