/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common;

import com.yeepay.g3.utils.common.CheckUtils;
import com.yeepay.g3.utils.common.ConvertUtils;
import com.yeepay.g3.utils.common.Resources;
import com.yeepay.g3.utils.common.json.JSONUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;

public class ReflectionUtils {
    private static final String Setter_Method_Prefix = "set";
    private static final String Getter_Method_Prefix = "get";
    private static final int ZERO = 0;
    private static final int FIRST = 1;
    static Map<String, Class> baseClassMap = new HashMap<String, Class>();

    public static Object executeMethod(Object target, String methodName) {
        return ReflectionUtils.executeMethod(target, methodName, null, null);
    }

    public static Object executeMethod(Object target, String methodName, Object[] paramValue, Class[] paramType) {
        if (paramType == null) {
            paramType = new Class[]{};
        }
        return ReflectionUtils.invokeMethod(target, methodName, paramValue, paramType);
    }

    public static void executeSetterMethodByField(Object object, String fieldName, Object[] paramValue, Class[] paramType) {
        ReflectionUtils.checkExecuteMethodParameter(object, fieldName);
        String methodName = ReflectionUtils.getMethodName(fieldName, Setter_Method_Prefix);
        ReflectionUtils.invokeMethod(object, methodName, paramValue, paramType);
    }

    public static Object executeGetterMethodByField(Object object, String fieldName, Class[] paramType) {
        if (paramType == null) {
            paramType = new Class[]{};
        }
        return ReflectionUtils.executeGetterMethodByField(object, fieldName, paramType, null);
    }

    public static Object executeGetterMethodByField(Object object, String fieldName, Class[] paramType, Object[] paramValue) {
        ReflectionUtils.checkExecuteMethodParameter(object, fieldName);
        String methodName = ReflectionUtils.getMethodName(fieldName, Getter_Method_Prefix);
        return ReflectionUtils.invokeMethod(object, methodName, paramValue, paramType);
    }

    private static void checkExecuteMethodParameter(Object object, String fieldName) {
        CheckUtils.notNull(object, "arugment object");
        CheckUtils.notEmpty(fieldName, "arugment fieldName");
    }

    private static String getMethodName(String fieldName, String Method_Prefix) {
        String firstChar = fieldName.substring(0, 1);
        String otherChar = fieldName.substring(1);
        return Method_Prefix + firstChar.toUpperCase() + otherChar;
    }

    private static Object invokeMethod(Object object, String methodName, Object[] paramValue, Class[] paramType) {
        Method method = null;
        try {
            method = ReflectionUtils.getMethod(object, methodName, paramType);
            if (method != null) {
                return method.invoke(object, paramValue);
            }
        }
        catch (SecurityException e) {
            throw new RuntimeException("Method: invokeMethodoccur error", e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Method: invokeMethodoccur error", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Method: invokeMethodoccur error", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Method: invokeMethodoccur error", e);
        }
        return null;
    }

    public static Method getMethod(Object target, String methodName, Class[] paramType) {
        if (paramType == null) {
            paramType = new Class[]{};
        }
        Method[] methods = target.getClass().getMethods();
        for (int index = 0; index < methods.length; ++index) {
            Method method = methods[index];
            if (!ReflectionUtils.methodNameIsEquals(method, methodName) || !ReflectionUtils.methodParameterTypeAreEquals(method, paramType)) continue;
            return method;
        }
        return null;
    }

    public static Class classForName(String className) {
        try {
            return Resources.classForName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Method: classForName occur error", e);
        }
    }

    private static boolean methodNameIsEquals(Method method, String methodName) {
        return method.getName().equals(methodName);
    }

    private static boolean methodParameterTypeAreEquals(Method method, Class[] types) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes == null && types == null) {
            return true;
        }
        if (parameterTypes.length != types.length) {
            return false;
        }
        for (int index = 0; index < parameterTypes.length; ++index) {
            Class<?> parameterType = parameterTypes[index];
            Class type = types[index];
            if (parameterType.equals(type)) continue;
            return false;
        }
        return true;
    }

    public static Class getGenericClass(Class clazz, int index) {
        Type[] params;
        Type genType = clazz.getGenericSuperclass();
        if (genType instanceof ParameterizedType && (params = ((ParameterizedType)genType).getActualTypeArguments()) != null && params.length > index) {
            return (Class)params[index];
        }
        return null;
    }

    public static Class getGenericClass(Class clazz) {
        return ReflectionUtils.getGenericClass(clazz, 0);
    }

    public static Object[] convertStringToObject(Class[] paramTypes, String[] paramValues) {
        Object[] values = new Object[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            Class clazz = paramTypes[i];
            Object value = null;
            value = clazz.isArray() ? (baseClassMap.keySet().contains(clazz.getComponentType().toString()) ? JSONUtils.jsonToArray(paramValues[i], baseClassMap.get(clazz.getComponentType().toString())) : JSONUtils.jsonToArray(paramValues[i], clazz.getComponentType())) : ConvertUtils.convert(clazz, paramValues[i]);
            values[i] = value;
        }
        return values;
    }

    public static Class makeInterface(String classFullName, String methodName, String returnValueClassName, String[] paramClassNames, String[] exceptionClassNames) throws NotFoundException, CannotCompileException {
        ClassPool pool = ClassPool.getDefault();
        pool.makePackage(pool.getClassLoader(), classFullName.substring(0, classFullName.lastIndexOf(".")));
        CtClass ctClass = pool.makeInterface(classFullName);
        CtClass returnValueClass = returnValueClassName != null ? pool.get(returnValueClassName) : CtClass.voidType;
        CtClass[] paramClass = paramClassNames != null ? pool.get(paramClassNames) : null;
        CtClass[] exceptionClass = exceptionClassNames != null ? pool.get(exceptionClassNames) : null;
        CtMethod ctMethod = CtNewMethod.abstractMethod((CtClass)returnValueClass, (String)methodName, (CtClass[])paramClass, (CtClass[])exceptionClass, (CtClass)ctClass);
        ctClass.addMethod(ctMethod);
        return ctClass.toClass();
    }

    static {
        baseClassMap.put("boolean", Boolean.class);
        baseClassMap.put("byte", Byte.class);
        baseClassMap.put("int", Integer.class);
        baseClassMap.put("long", Long.class);
        baseClassMap.put("short", Short.class);
        baseClassMap.put("double", Double.class);
        baseClassMap.put("float", Float.class);
        baseClassMap.put("char", Character.class);
    }
}

