/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common;

import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class ServiceLocator {
    public static String SERVICE_CONFIG = "classpath*:spring/beans-*.xml";
    public static String DATASOURCE_CONFIG = "classpath*:datasource/datasource-*.xml";
    private static ServiceLocator sInstance = null;
    private static Object lock = new Object();
    private ConfigurableApplicationContext beanFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceLocator instance(String configPath) {
        if (sInstance == null) {
            Object object = lock;
            synchronized (object) {
                if (sInstance == null) {
                    sInstance = new ServiceLocator(configPath);
                }
            }
        }
        return sInstance;
    }

    private ServiceLocator(String configPath) {
        if (configPath != null) {
            ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(configPath.split(","));
            this.beanFactory = context;
        }
    }

    public ApplicationContext getContext() {
        return this.beanFactory;
    }

    public synchronized void shutdown() {
        if (this.beanFactory != null) {
            this.beanFactory.close();
            this.beanFactory = null;
        }
    }
}

