/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.regex.Pattern;

public class StringUtils
extends org.apache.commons.lang.StringUtils {
    public static final String EMPTY = "";
    public static final int INDEX_NOT_FOUND = -1;
    private static final int PAD_LIMIT = 8192;
    private static final Pattern WHITESPACE_BLOCK = Pattern.compile("\\s+");
    private static boolean sunAvailable = false;
    private static Method sunDecomposeMethod = null;
    private static final Pattern sunPattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
    private static boolean java6Available = false;
    private static Method java6NormalizeMethod = null;
    private static Object java6NormalizerFormNFD = null;
    private static final Pattern java6Pattern = sunPattern;

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !StringUtils.isEmpty(cs);
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !StringUtils.isBlank(cs);
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static String trimToNull(String str) {
        String ts = StringUtils.trim(str);
        return StringUtils.isEmpty((String)ts) ? null : ts;
    }

    public static String trimToEmpty(String str) {
        return str == null ? EMPTY : str.trim();
    }

    public static String strip(String str) {
        return StringUtils.strip(str, null);
    }

    public static String stripToNull(String str) {
        if (str == null) {
            return null;
        }
        return (str = StringUtils.strip(str, null)).length() == 0 ? null : str;
    }

    public static String stripToEmpty(String str) {
        return str == null ? EMPTY : StringUtils.strip(str, null);
    }

    public static String strip(String str, String stripChars) {
        if (StringUtils.isEmpty((String)str)) {
            return str;
        }
        str = StringUtils.stripStart(str, stripChars);
        return StringUtils.stripEnd(str, stripChars);
    }

    public static String stripStart(String str, String stripChars) {
        int start;
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        if (stripChars == null) {
            for (start = 0; start != strLen && Character.isWhitespace(str.charAt(start)); ++start) {
            }
        } else {
            if (stripChars.length() == 0) {
                return str;
            }
            while (start != strLen && stripChars.indexOf(str.charAt(start)) != -1) {
                ++start;
            }
        }
        return str.substring(start);
    }

    public static String stripEnd(String str, String stripChars) {
        int end;
        if (str == null || (end = str.length()) == 0) {
            return str;
        }
        if (stripChars == null) {
            while (end != 0 && Character.isWhitespace(str.charAt(end - 1))) {
                --end;
            }
        } else {
            if (stripChars.length() == 0) {
                return str;
            }
            while (end != 0 && stripChars.indexOf(str.charAt(end - 1)) != -1) {
                --end;
            }
        }
        return str.substring(0, end);
    }

    public static String[] stripAll(String ... strs) {
        return StringUtils.stripAll(strs, null);
    }

    public static String[] stripAll(String[] strs, String stripChars) {
        int strsLen;
        if (strs == null || (strsLen = strs.length) == 0) {
            return strs;
        }
        String[] newArr = new String[strsLen];
        for (int i = 0; i < strsLen; ++i) {
            newArr[i] = StringUtils.strip(strs[i], stripChars);
        }
        return newArr;
    }

    public static String stripAccents(String input) {
        if (input == null) {
            return null;
        }
        try {
            String result = null;
            if (java6Available) {
                result = StringUtils.removeAccentsJava6(input);
            } else if (sunAvailable) {
                result = StringUtils.removeAccentsSUN(input);
            } else {
                throw new UnsupportedOperationException("The stripAccents(CharSequence) method requires at least Java 1.6 or a Sun JVM");
            }
            return result;
        }
        catch (IllegalArgumentException iae) {
            throw new RuntimeException("IllegalArgumentException occurred", iae);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("IllegalAccessException occurred", iae);
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException("InvocationTargetException occurred", ite);
        }
        catch (SecurityException se) {
            throw new RuntimeException("SecurityException occurred", se);
        }
    }

    private static String removeAccentsJava6(CharSequence text) throws IllegalAccessException, InvocationTargetException {
        if (!java6Available || java6NormalizerFormNFD == null) {
            throw new IllegalStateException("java.text.Normalizer is not available");
        }
        String result = (String)java6NormalizeMethod.invoke(null, text, java6NormalizerFormNFD);
        result = java6Pattern.matcher(result).replaceAll(EMPTY);
        return result;
    }

    private static String removeAccentsSUN(CharSequence text) throws IllegalAccessException, InvocationTargetException {
        if (!sunAvailable) {
            throw new IllegalStateException("sun.text.Normalizer is not available");
        }
        String result = (String)sunDecomposeMethod.invoke(null, text, Boolean.FALSE, 0);
        result = sunPattern.matcher(result).replaceAll(EMPTY);
        return result;
    }

    public static boolean equals(CharSequence cs1, CharSequence cs2) {
        return cs1 == null ? cs2 == null : cs1.equals(cs2);
    }

    public static String toSBC(String input) {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == ' ') {
                c[i] = 12288;
                continue;
            }
            if (c[i] >= '\u007f') continue;
            c[i] = (char)(c[i] + 65248);
        }
        return new String(c);
    }

    public static String toDBC(String input) {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '\u3000') {
                c[i] = 32;
                continue;
            }
            if (c[i] <= '\uff00' || c[i] >= '\uff5f') continue;
            c[i] = (char)(c[i] - 65248);
        }
        return new String(c);
    }

    public static String fillBitsWithPlaceholder(String placeholder, String str, int bitNum) {
        if (str == null) {
            throw new IllegalArgumentException("str must not be null");
        }
        if (placeholder == null || bitNum <= 0) {
            return str;
        }
        if (str.length() < bitNum) {
            StringBuffer buffer = new StringBuffer();
            for (int index = str.length(); index < bitNum; ++index) {
                buffer.append(placeholder);
            }
            buffer.append(str);
            return buffer.toString();
        }
        return str;
    }

    public static String spliceIntegerToString(Integer addend, Integer summand) {
        if (addend == null || summand == null) {
            throw new IllegalArgumentException("addend and summand arguments must not be null");
        }
        return String.valueOf(addend) + String.valueOf(summand);
    }

    public static String defaultIfNull(String str) {
        return str != null ? str : EMPTY;
    }

    public static String rightPadWithBytes(String str, int size, char padChar, String encoding) {
        return StringUtils.padWithBytes(str, size, padChar, encoding, false);
    }

    public static String leftPadWithBytes(String str, int size, char padChar, String encoding) {
        return StringUtils.padWithBytes(str, size, padChar, encoding, true);
    }

    private static String padWithBytes(String str, int size, char padChar, String encoding, boolean isLeft) {
        int strLen;
        if (str == null) {
            return null;
        }
        try {
            strLen = str.getBytes(encoding).length;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UnsupportedEncoding:" + encoding, e);
        }
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        char[] padChars = new char[pads];
        for (int i = 0; i < padChars.length; ++i) {
            padChars[i] = padChar;
        }
        if (isLeft) {
            return new String(padChars) + str;
        }
        return str + new String(padChars);
    }

    public static String substringByByte(String str, int begin, int end) {
        char c;
        Charset charset = Charset.forName("UTF-8");
        if (StringUtils.isEmpty((String)str) || begin < 0 || str.getBytes(charset).length < end) {
            return str;
        }
        int maxLen = end - begin;
        if (maxLen < 1) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        int len = 0;
        int i = begin;
        while (len < maxLen && (len += String.valueOf(c = str.charAt(i)).getBytes(charset).length) <= maxLen) {
            buf.append(c);
            ++i;
        }
        return buf.toString();
    }

    public static boolean isChineseChar(char c) {
        Charset charset = Charset.forName("UTF-8");
        return String.valueOf(c).getBytes(charset).length > 2;
    }

    public static void main(String[] args) {
        System.out.println(StringUtils.padWithBytes("\u5317\u4eac\u901a\u878d\u901a\u4fe1\u606f\u6280\u672f\u6709\u9650\u516c\u53f8\u6df1\u5733\u5206\u516c\u53f8", 60, ' ', "GBK", true) + "|");
        System.out.println(StringUtils.padWithBytes("\u5317\u4eac\u901a\u878d\u901a\u4fe1\u606f\u6280\u672f\u6709\u9650\u516c\u53f8\u6df1\u5733", 60, ' ', "GBK", true) + "|");
    }

    static {
        try {
            Class<?> normalizerFormClass = Thread.currentThread().getContextClassLoader().loadClass("java.text.Normalizer$Form");
            java6NormalizerFormNFD = normalizerFormClass.getField("NFD").get(null);
            Class<?> normalizerClass = Thread.currentThread().getContextClassLoader().loadClass("java.text.Normalizer");
            java6NormalizeMethod = normalizerClass.getMethod("normalize", CharSequence.class, normalizerFormClass);
            java6Available = true;
        }
        catch (ClassNotFoundException e) {
            java6Available = false;
        }
        catch (NoSuchFieldException e) {
            java6Available = false;
        }
        catch (IllegalAccessException e) {
            java6Available = false;
        }
        catch (NoSuchMethodException e) {
            java6Available = false;
        }
        try {
            Class<?> normalizerClass = Thread.currentThread().getContextClassLoader().loadClass("sun.text.Normalizer");
            sunDecomposeMethod = normalizerClass.getMethod("decompose", String.class, Boolean.TYPE, Integer.TYPE);
            sunAvailable = true;
        }
        catch (ClassNotFoundException e) {
            sunAvailable = false;
        }
        catch (NoSuchMethodException e) {
            sunAvailable = false;
        }
    }
}

