/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common;

import com.yeepay.g3.utils.common.StringUtils;
import com.yeepay.g3.utils.common.threadcontext.ThreadContext;
import com.yeepay.g3.utils.common.threadcontext.ThreadContextType;
import java.util.HashMap;
import java.util.Map;

public class ThreadContextUtils {
    public static final String KEY_GUID = "_thread_uid";
    public static final String KEY_TRANSFER_LEVEL = "_transfer_level";
    public static final String KEY_TRANSFER_LEVEL_START_VAL = "1";
    private static Map<ClassLoader, String> appNameCache = new HashMap<ClassLoader, String>();
    private static ThreadLocal<ThreadContext> threadContext = new ThreadLocal<ThreadContext>(){

        @Override
        protected ThreadContext initialValue() {
            return null;
        }
    };

    public static void clearContext() {
        threadContext.remove();
    }

    @Deprecated
    public static void initContext(String sourceUID, ThreadContextType type) {
        ThreadContextUtils.initContext(null, sourceUID, type);
    }

    public static void initContext(String appName, String sourceUID, ThreadContextType type) {
        ThreadContextUtils.initContext(appName, sourceUID, type, KEY_TRANSFER_LEVEL_START_VAL);
    }

    public static void initContext(String appName, String sourceUID, ThreadContextType type, String transferLevel) {
        if (threadContext.get() != null) {
            throw new RuntimeException("thread context already initialized");
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        String cachedAppName = appNameCache.get(cl);
        if (StringUtils.isBlank((String)appName)) {
            appName = cachedAppName;
        } else if (StringUtils.isBlank((String)cachedAppName) && !StringUtils.equals((String)appName, (String)"monitor")) {
            appNameCache.put(cl, appName);
        }
        ThreadContext context = new ThreadContext(appName, sourceUID, type, transferLevel);
        threadContext.set(context);
    }

    public static boolean contextInitialized() {
        return threadContext.get() != null;
    }

    public static ThreadContext getContext() {
        return threadContext.get();
    }

    public static String getAppName() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return appNameCache.get(cl);
    }
}

