/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common;

import com.yeepay.g3.utils.common.FormatUtils;
import java.util.Date;
import java.util.UUID;

public class UIDGenerator {
    private static final int[] DEFAULT_CONFOUNDER = new int[]{3, 6, 7, 1, 8, 9, 5, 2};

    public static String getUUID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    private static long confuse(long num, int[] confounder) {
        int i;
        int length = confounder.length;
        String tempStr = num + "";
        int numLength = tempStr.length();
        if (length < numLength) {
            throw new RuntimeException("confounder length must greater then number length, " + length + " : " + numLength);
        }
        String output = "";
        char[] input = tempStr.toCharArray();
        int confounderIndex = Integer.parseInt(input[input.length - 1] + "") % 8;
        int paddingLength = length - numLength;
        for (i = 0; i < paddingLength; ++i) {
            confounderIndex = (confounderIndex + 1) % 8;
            output = output + confounder[confounderIndex] % 10;
        }
        for (i = 0; i < numLength; ++i) {
            confounderIndex = (confounderIndex + 1) % 8;
            output = output + (Integer.parseInt(input[i] + "") + confounder[confounderIndex]) % 10;
        }
        try {
            return Long.parseLong(output);
        }
        catch (Exception e) {
            throw new RuntimeException("confuse number overflow : " + output);
        }
    }

    public static String generateSysUID(String sysFlag) {
        if (sysFlag == null || sysFlag.length() != 2) {
            throw new RuntimeException("sysFlag must be 2 length");
        }
        return sysFlag + UIDGenerator.getUUID();
    }

    public static String generateBizUID(long sequence, String bizFlag) {
        return UIDGenerator.generateBizUID(sequence, bizFlag, new Date());
    }

    public static String generateBizUID(long sequence, String bizFlag, Date date) {
        if (bizFlag == null || bizFlag.length() != 2) {
            throw new RuntimeException("bizFlag must be 2 length");
        }
        String dateStr = FormatUtils.formatDate(date, "yyMMdd", null);
        return bizFlag + "A" + dateStr + UIDGenerator.confuse(sequence, DEFAULT_CONFOUNDER);
    }
}

