/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common;

import com.yeepay.g3.utils.common.IDCardUtils;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class ValidateUtils {
    public static boolean isInteger(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        return pattern.matcher(str).matches();
    }

    public static boolean isDouble(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[.\\d]*$");
        return pattern.matcher(str).matches();
    }

    public static boolean isEmail(String str) {
        Pattern pattern = Pattern.compile("^\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*$");
        return pattern.matcher(str).matches();
    }

    public static boolean isChinese(String str) {
        Pattern pattern = Pattern.compile("[\u0391-\uffe5]+$");
        return pattern.matcher(str).matches();
    }

    public static boolean isPrime(int x) {
        if (x <= 7 && (x == 2 || x == 3 || x == 5 || x == 7)) {
            return true;
        }
        if (x % 2 == 0) {
            return false;
        }
        if (x % 3 == 0) {
            return false;
        }
        if (x % 5 == 0) {
            return false;
        }
        int end = (int)Math.sqrt(x);
        for (int c = 7; c <= end; c += 6) {
            if (x % c == 0) {
                return false;
            }
            if (x % (c += 4) == 0) {
                return false;
            }
            if (x % (c += 2) == 0) {
                return false;
            }
            if (x % (c += 4) == 0) {
                return false;
            }
            if (x % (c += 2) == 0) {
                return false;
            }
            if (x % (c += 4) == 0) {
                return false;
            }
            if (x % (c += 6) == 0) {
                return false;
            }
            if (x % (c += 2) != 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isMobile(String mobile) {
        Pattern pattern = Pattern.compile("^1[3|4|5|8|7][0-9]{9}$");
        return pattern.matcher(mobile).matches();
    }

    public static boolean isPhone(String phone) {
        Pattern pattern = Pattern.compile("^0[0-9]{2,3}[-|\uff0d][0-9]{7,8}([-|\uff0d][0-9]{1,4})?$");
        return pattern.matcher(phone).matches();
    }

    public static boolean isPost(String post) {
        Pattern pattern = Pattern.compile("^[0-9]{6}$");
        return pattern.matcher(post).matches();
    }

    public static boolean isDate(String dateStr) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = df.parse(dateStr);
        }
        catch (ParseException e) {
            return false;
        }
        return date != null;
    }

    public static boolean isDateTime(String dateTime) {
        int first = dateTime.indexOf(":");
        int last = dateTime.lastIndexOf(":");
        if (first == -1) {
            return false;
        }
        SimpleDateFormat df = null;
        df = first == last ? new SimpleDateFormat("yyyy-MM-dd hh:mm") : new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        Date date = null;
        try {
            date = df.parse(dateTime);
        }
        catch (ParseException e) {
            return false;
        }
        return date == null;
    }

    public static boolean isURL(String url) {
        Pattern pattern = Pattern.compile("^(https?|ftp):\\/\\/(((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:)*@)?(((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5]))|((([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.)+(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.?)(:\\d*)?)(\\/((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)+(\\/(([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)*)*)?)?(\\?((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)|[\\uE000-\\uF8FF]|\\/|\\?)*)?(\\#((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)|\\/|\\?)*)?$");
        return pattern.matcher(url).matches();
    }

    public static boolean isIP(String ip) {
        Pattern pattern = Pattern.compile("^(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])$");
        return pattern.matcher(ip).matches();
    }

    public static boolean isMac(String mac) {
        Pattern pattern = Pattern.compile("^([0-9a-fA-F]{2})(([\\s:-][0-9a-fA-F]{2}){5})$");
        return pattern.matcher(mac).matches();
    }

    public static boolean isBankCard(String bankCard) {
        String nonCheckCodeCardId;
        if (!StringUtils.isBlank((String)bankCard) && (nonCheckCodeCardId = bankCard.substring(0, bankCard.length() - 1)).matches("\\d+")) {
            char[] chs = nonCheckCodeCardId.toCharArray();
            int luhmSum = 0;
            int i = chs.length - 1;
            int j = 0;
            while (i >= 0) {
                int k = chs[i] - 48;
                if (j % 2 == 0) {
                    k *= 2;
                    k = k / 10 + k % 10;
                }
                luhmSum += k;
                --i;
                ++j;
            }
            char b = luhmSum % 10 == 0 ? (char)'0' : (char)(10 - luhmSum % 10 + 48);
            return bankCard.charAt(bankCard.length() - 1) == b;
        }
        return false;
    }

    private static List<String> generateBankCard(int count) {
        long l = 100000000000000000L;
        ArrayList<String> list = new ArrayList<String>();
        for (int a = 1; a <= count; ++a) {
            String s = String.valueOf(l + (long)a);
            char[] chs = s.toCharArray();
            int luhmSum = 0;
            int i = chs.length - 1;
            int j = 0;
            while (i >= 0) {
                int k = chs[i] - 48;
                if (j % 2 == 0) {
                    k *= 2;
                    k = k / 10 + k % 10;
                }
                luhmSum += k;
                --i;
                ++j;
            }
            char b = luhmSum % 10 == 0 ? (char)'0' : (char)(10 - luhmSum % 10 + 48);
            String bankcard = s + b;
            if (!ValidateUtils.isBankCard(bankcard)) continue;
            list.add(s + b);
        }
        return list;
    }

    private static List<String> generateIDCard(int count) {
        int a = 100000000;
        if (count + a > 1000000000) {
            throw new RuntimeException("\u6570\u91cf\u8fc7\u5927");
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int b = 1; b <= count; ++b) {
            String s = String.valueOf(a + b);
            s = s.substring(0, 6) + "19861221" + s.substring(6);
            char[] chars = s.toCharArray();
            int si = 0;
            for (int i = 0; i < 17; ++i) {
                si += (chars[i] - 48) * (new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2})[i];
            }
            char last = (new char[]{'1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'})[si % 11];
            String card = s + last;
            if (!IDCardUtils.verifi(card)) continue;
            list.add(card);
        }
        return list;
    }

    public static void checkStrMinLength(String str, Integer minLength, String message) {
        if (str.trim().length() < minLength) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void checkStrMaxLength(String str, Integer maxLength, String message) {
        if (str.trim().length() > maxLength) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void checkNotNull(Object obj, String message) {
        if (obj == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void checkNotEmpty(Object obj, String message) {
        if (obj == null) {
            throw new IllegalArgumentException(message);
        }
        if (obj instanceof String && obj.toString().trim().length() == 0) {
            throw new IllegalArgumentException(message);
        }
        if (obj.getClass().isArray() && Array.getLength(obj) == 0) {
            throw new IllegalArgumentException(message);
        }
        if (obj instanceof Collection && ((Collection)obj).isEmpty()) {
            throw new IllegalArgumentException(message);
        }
        if (obj instanceof Map && ((Map)obj).isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static boolean isNull(Object obj) {
        return obj == null;
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String && obj.toString().trim().length() == 0) {
            return true;
        }
        if (obj.getClass().isArray() && Array.getLength(obj) == 0) {
            return true;
        }
        if (obj instanceof Collection && ((Collection)obj).isEmpty()) {
            return true;
        }
        return obj instanceof Map && ((Map)obj).isEmpty();
    }
}

