/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common.datasource;

import com.yeepay.g3.utils.common.encrypt.AES;
import java.util.Properties;

public class Config {
    public static final String AES_KEY = "I am a fool, OK?";
    public static int MIN_POOL_SIZE = 10;
    public static int MAX_POOL_SIZE = 20;
    public static int DEFAULT_INCREMENT = 5;
    public static int DEFAULT_TEST_PERIOD = 30;
    public static int DEFAULT_MAX_STATE_PER_CONN = 100;
    public static int DEFAULT_NUM_HELPER_THREADS = 5;
    public static int DEFAULT_INCREMENT_RETRY = 1;
    public static int DEFAULT_UNRETURNED_CONNECTION_TIMEOUT = 0;
    public static int DEFAULT_MAX_IDLE_TIME = 300;
    public static int DEFAULT_CHECKOUT_TIME = 10000;
    public static int LOGIN_TIMEOUT = 10;
    public static int QUERY_TIMEOUT = 60;
    public static boolean ENABLE_CANCEL_TIMEOUT = true;
    private String driverClass;
    private String jdbcUrl;
    private String user;
    private String password;
    private String schema;
    private String loginTimeout;
    private String queryTimeout;
    private String enableCancelTimeout;
    private int maxPoolSize;
    private int minPoolSize;
    private int acquireIncrement;
    private int acquireIncrementRetry;
    private int idleConnectionTestPeriod;
    private int maxStatementsPerConnection;
    private int numHelperThreads;
    private int maxStatements;
    private int maxConnectionAge;
    private int maxIdleTime;
    private int checkoutTimeout;
    private int unreturnedConnectionTimeout;
    private boolean useMonitor = true;
    private long releaseAlarmThreshold = 5000L;
    private long blockingThreshold = 10000L;

    public static Config instance(Properties prop) {
        Config config = new Config();
        config.setJdbcUrl(prop.getProperty("jdbcUrl"));
        config.setDriverClass(prop.getProperty("driverClass"));
        config.setUser(prop.getProperty("user"));
        config.setPassword(prop.getProperty("password"));
        config.setSchema(prop.getProperty("schema"));
        config.setLoginTimeout(prop.getProperty("loginTimeout"));
        config.setEnableCancelTimeout(prop.getProperty("enableCancelTimeout"));
        config.setQueryTimeout(prop.getProperty("queryTimeout"));
        String p_min = prop.getProperty("min");
        String p_max = prop.getProperty("max");
        String p_increment = prop.getProperty("increment");
        String p_incrementRetry = prop.getProperty("incrementRetry");
        String p_testperiod = prop.getProperty("testperiod");
        String p_maxIdle = prop.getProperty("maxIdle");
        String p_checkoutTimeout = prop.getProperty("checkoutTimeout");
        String p_unreturnedConnectionTimeout = prop.getProperty("unreturnedConnectionTimeout");
        String maxStatementPerConn = prop.getProperty("maxStatementPerConnection");
        String numHelperThreads = prop.getProperty("numHelperThreads");
        String maxStatements = prop.getProperty("maxStatements");
        String maxConnectionAge = prop.getProperty("maxConnectionAge");
        String useMonitor = prop.getProperty("useMonitor");
        String releaseAlarmThreshold = prop.getProperty("releaseAlarmThreshold");
        String blockingThreshold = prop.getProperty("blockingThreshold");
        config.setMinPoolSize(p_min);
        config.setMaxPoolSize(p_max);
        config.setAcquireIncrement(p_increment);
        config.setAcquireIncrementRetry(p_incrementRetry);
        config.setIdleConnectionTestPeriod(p_testperiod);
        config.setMaxStatementsPerConnection(maxStatementPerConn);
        config.setNumHelperThreads(numHelperThreads);
        config.setMaxStatements(maxStatements);
        config.setMaxConnectionAge(maxConnectionAge);
        config.setMaxIdleTime(p_maxIdle);
        config.setCheckoutTimeout(p_checkoutTimeout);
        config.setUnreturnedConnectionTimeout(p_unreturnedConnectionTimeout);
        config.setUseMonitor(useMonitor);
        config.setReleaseAlarmThreshold(releaseAlarmThreshold);
        config.setBlockingThreshold(blockingThreshold);
        return config;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = AES.decryptFromBase64(password, AES_KEY);
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getLoginTimeout() {
        return this.loginTimeout;
    }

    public void setLoginTimeout(String loginTimeout) {
        this.loginTimeout = loginTimeout == null ? String.valueOf(LOGIN_TIMEOUT) : loginTimeout;
    }

    public String getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(String queryTimeout) {
        this.queryTimeout = queryTimeout == null ? String.valueOf(QUERY_TIMEOUT) : queryTimeout;
    }

    public String getEnableCancelTimeout() {
        return this.enableCancelTimeout;
    }

    public void setEnableCancelTimeout(String enableCancelTimeout) {
        this.enableCancelTimeout = enableCancelTimeout == null ? String.valueOf(ENABLE_CANCEL_TIMEOUT) : enableCancelTimeout;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(String maxPoolSize) {
        this.maxPoolSize = maxPoolSize == null ? MAX_POOL_SIZE : Integer.parseInt(maxPoolSize);
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(String minPoolSize) {
        this.minPoolSize = minPoolSize == null ? MIN_POOL_SIZE : Integer.parseInt(minPoolSize);
    }

    public void setIdleConnectionTestPeriod(String period) {
        this.idleConnectionTestPeriod = period == null ? DEFAULT_TEST_PERIOD : Integer.parseInt(period);
    }

    public void setMaxIdleTime(String _maxIdleTime) {
        this.maxIdleTime = _maxIdleTime == null ? DEFAULT_MAX_IDLE_TIME : Integer.parseInt(_maxIdleTime);
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public int getAcquireIncrement() {
        return this.acquireIncrement;
    }

    public int getIdleConnectionTestPeriod() {
        return this.idleConnectionTestPeriod;
    }

    public void setAcquireIncrement(String acquireIncrement) {
        this.acquireIncrement = acquireIncrement == null ? DEFAULT_INCREMENT : Integer.parseInt(acquireIncrement);
    }

    public int getMaxStatementsPerConnection() {
        return this.maxStatementsPerConnection;
    }

    public void setMaxStatementsPerConnection(String maxStatementsPerConnection) {
        this.maxStatementsPerConnection = maxStatementsPerConnection == null ? DEFAULT_MAX_STATE_PER_CONN : Integer.parseInt(maxStatementsPerConnection);
    }

    public int getNumHelperThreads() {
        return this.numHelperThreads;
    }

    public void setNumHelperThreads(String numHelperThreads) {
        this.numHelperThreads = numHelperThreads == null ? DEFAULT_NUM_HELPER_THREADS : Integer.parseInt(numHelperThreads);
    }

    public int getMaxStatements() {
        return this.maxStatements;
    }

    public void setMaxStatements(String maxStatements) {
        this.maxStatements = maxStatements == null ? Integer.MIN_VALUE : Integer.parseInt(maxStatements);
    }

    public int getMaxConnectionAge() {
        return this.maxConnectionAge;
    }

    public void setMaxConnectionAge(String maxConnectionAge) {
        this.maxConnectionAge = maxConnectionAge == null ? Integer.MIN_VALUE : Integer.parseInt(maxConnectionAge);
    }

    public int getCheckoutTimeout() {
        return this.checkoutTimeout;
    }

    public void setCheckoutTimeout(String _checkoutTimeout) {
        this.checkoutTimeout = _checkoutTimeout == null ? DEFAULT_CHECKOUT_TIME : Integer.parseInt(_checkoutTimeout);
    }

    public boolean isUseMonitor() {
        return this.useMonitor;
    }

    public void setUseMonitor(String useMonitor) {
        this.useMonitor = useMonitor == null ? true : Boolean.valueOf(useMonitor);
    }

    public long getReleaseAlarmThreshold() {
        return this.releaseAlarmThreshold;
    }

    public void setReleaseAlarmThreshold(String releaseAlarmThreshold) {
        this.releaseAlarmThreshold = releaseAlarmThreshold == null ? 5000L : Long.valueOf(releaseAlarmThreshold);
    }

    public long getBlockingThreshold() {
        return this.blockingThreshold;
    }

    public void setBlockingThreshold(String blockingThreshold) {
        this.blockingThreshold = blockingThreshold == null ? 10000L : Long.valueOf(blockingThreshold);
    }

    public int getAcquireIncrementRetry() {
        return this.acquireIncrementRetry;
    }

    public void setAcquireIncrementRetry(String _acquireIncrementRetry) {
        this.acquireIncrementRetry = _acquireIncrementRetry == null ? DEFAULT_INCREMENT_RETRY : Integer.parseInt(_acquireIncrementRetry);
    }

    public int getUnreturnedConnectionTimeout() {
        return this.unreturnedConnectionTimeout;
    }

    public void setUnreturnedConnectionTimeout(String _unreturnedConnectionTimeout) {
        this.unreturnedConnectionTimeout = _unreturnedConnectionTimeout == null ? DEFAULT_UNRETURNED_CONNECTION_TIMEOUT : Integer.parseInt(_unreturnedConnectionTimeout);
    }
}

