/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common.datasource;

import com.yeepay.g3.utils.common.datasource.Config;
import com.yeepay.g3.utils.common.datasource.MonitorDataSource;
import com.yeepay.g3.utils.common.datasource.YeepayComboPooledDataSource;
import com.yeepay.g3.utils.common.log.Logger;
import com.yeepay.g3.utils.common.log.LoggerFactory;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.beans.factory.FactoryBean;

public class DataSourceFactoryBean
implements FactoryBean {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceFactoryBean.class);
    private String name;
    private boolean useMonitor = false;
    private static String SYSPROP_DBCONFIGPATH = "dbconfigpath";
    private static Map<String, DataSource> datasources = new HashMap<String, DataSource>();

    public Object getObject() throws Exception {
        DataSource ds = datasources.get(this.name);
        if (ds == null) {
            ds = this.creatDataSource();
            datasources.put(this.name, ds);
        } else {
            logger.info("load datasource : " + this.name);
        }
        return ds;
    }

    private DataSource creatDataSource() {
        logger.info("create datasource : " + this.name);
        String dbConfigPath = System.getProperty(SYSPROP_DBCONFIGPATH);
        InputStream is = null;
        if (dbConfigPath == null) {
            logger.info("no dbConfigPath found in system properties, load dbconf from classpath");
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream("dbconf/" + this.name + ".properties");
        } else {
            if (!dbConfigPath.endsWith("/")) {
                dbConfigPath = dbConfigPath + "/";
            }
            logger.info("load dbconf from : " + dbConfigPath + this.name + ".properties");
            try {
                is = new FileInputStream(new File(dbConfigPath + this.name + ".properties"));
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("load dbconf file fail : " + e.getMessage(), e);
            }
        }
        try {
            Properties prop = new Properties();
            prop.load(is);
            Config config = Config.instance(prop);
            YeepayComboPooledDataSource ds = new YeepayComboPooledDataSource();
            ds.doConfig(config);
            Object result = ds;
            if (this.useMonitor || config.isUseMonitor() || this.isEnvEnableMonitor()) {
                logger.info("use MonitorDataSource : " + this.name);
                MonitorDataSource monitor = new MonitorDataSource();
                monitor.setDataSource((DataSource)((Object)ds));
                monitor.setName(this.name);
                monitor.setReleaseAlarmThreshold(config.getReleaseAlarmThreshold());
                monitor.setBlockingThreshold(config.getBlockingThreshold());
                result = monitor;
            }
            return result;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (PropertyVetoException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isEnvEnableMonitor() {
        String value = System.getProperty("yeepay.datasource.monitor");
        if ("true".equals(value)) {
            return true;
        }
        value = System.getenv("YEEPAY_DATASOURCE_MONITOR");
        return "true".equals(value);
    }

    public Class getObjectType() {
        return DataSource.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUseMonitor(boolean useMonitor) {
        this.useMonitor = useMonitor;
    }
}

