/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common.datasource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class FileLoader {
    public static InputStream loadFile(String fileName) throws FileNotFoundException {
        InputStream stream = null;
        stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
        if (stream == null) {
            stream = FileLoader.class.getResourceAsStream(fileName);
        }
        if (stream == null) {
            try {
                stream = FileLoader.loadFileFromUserDir(fileName);
            }
            catch (FileNotFoundException e) {
                stream = FileLoader.loadFileFromUserDirParent(fileName);
            }
        }
        return stream;
    }

    private static String processFilePath(String userDir, String fileName) {
        String file = fileName;
        if (file.startsWith("/")) {
            file = file.substring(1);
            file = userDir + File.separator + file;
        } else {
            file = userDir + File.separator + file;
        }
        return file;
    }

    private static InputStream loadFileFromUserDir(String fileName) throws FileNotFoundException {
        String userDir = System.getProperty("user.dir");
        String filePath = FileLoader.processFilePath(userDir, fileName);
        return new FileInputStream(new File(filePath));
    }

    private static InputStream loadFileFromUserDirParent(String fileName) throws FileNotFoundException {
        String userDir = System.getProperty("user.dir");
        int last = userDir.lastIndexOf(File.separator);
        if (last > 0) {
            userDir = userDir.substring(0, last);
        }
        String filePath = FileLoader.processFilePath(userDir, fileName);
        return new FileInputStream(new File(filePath));
    }
}

