/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common.datasource;

import com.yeepay.g3.utils.common.datasource.MonitorDataSource;
import com.yeepay.g3.utils.common.datasource.MonitorStatement;
import com.yeepay.g3.utils.common.datasource.MonitorUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;

public class MonitorConnection
implements InvocationHandler {
    private MonitorDataSource monitorDataSource;
    private ConcurrentHashMap<MonitorStatement, MonitorStatement> statements = new ConcurrentHashMap();
    private long id;
    private Connection proxy;
    private Connection connection;
    private Thread ownerThread;
    private Date createdTime;
    private Date proxyTime;
    private String threadStack;
    private String status;

    public MonitorConnection(MonitorDataSource monitorDataSource) {
        this.monitorDataSource = monitorDataSource;
    }

    public MonitorDataSource getMonitorDataSource() {
        return this.monitorDataSource;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Connection getProxy() {
        if (this.proxy == null) {
            Class[] classes = new Class[]{Connection.class};
            this.proxy = (Connection)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), classes, (InvocationHandler)this);
        }
        return this.proxy;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Thread getOwnerThread() {
        return this.ownerThread;
    }

    public void setOwnerThread(Thread ownerThread) {
        this.ownerThread = ownerThread;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Date getProxyTime() {
        return this.proxyTime;
    }

    public void setProxyTime(Date proxyTime) {
        this.proxyTime = proxyTime;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("close".equals(method.getName())) {
            this.close();
            return null;
        }
        Object result = MonitorUtils.invoke(method, this.connection, args);
        if (this.monitorDataSource.isEnableMonitorStatement() && result != null) {
            if ("createStatement".equals(method.getName())) {
                MonitorStatement statement = new MonitorStatement(this, this.monitorDataSource, null, (Statement)result);
                this.statements.put(statement, statement);
                result = statement.getProxy();
            } else if ("prepareStatement".equals(method.getName())) {
                String preparedSql = null;
                if (args != null && args.length > 0 && args[0] instanceof String) {
                    preparedSql = (String)args[0];
                }
                if (preparedSql != null) {
                    MonitorStatement statement = new MonitorStatement(this, this.monitorDataSource, preparedSql, (Statement)result);
                    this.statements.put(statement, statement);
                    result = statement.getProxy();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        try {
            this.connection.close();
        }
        finally {
            this.monitorDataSource.releaseConnection(this.connection);
        }
    }

    public String getThreadStack() {
        return this.threadStack;
    }

    public void setThreadStack(String threadStack) {
        this.threadStack = threadStack;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    protected void releaseStatement(MonitorStatement monitorStatement) {
        if ((monitorStatement = this.statements.remove(monitorStatement)) == null) {
            return;
        }
    }
}

