/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common.datasource;

import com.yeepay.g3.utils.common.DebugUtils;
import com.yeepay.g3.utils.common.datasource.MonitorConnection;
import com.yeepay.g3.utils.common.datasource.MonitorDataSourceManager;
import com.yeepay.g3.utils.common.datasource.MonitorDataSourceSummary;
import com.yeepay.g3.utils.common.log.Logger;
import com.yeepay.g3.utils.common.log.LoggerFactory;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.sql.DataSource;

public class MonitorDataSource
implements DataSource {
    private static final Logger logger = LoggerFactory.getLogger(MonitorDataSource.class);
    private static final AtomicLong SEQ = new AtomicLong();
    private String name;
    private DataSource dataSource;
    private ConcurrentHashMap<MonitorConnection, MonitorConnection> allMonitors = new ConcurrentHashMap();
    private ConcurrentHashMap<Connection, MonitorConnection> connections = new ConcurrentHashMap();
    private boolean enableMonitorStatement = false;
    private long releaseAlarmThreshold = -1L;
    private long blockingThreshold = -1L;
    private long executeBlockingThreshold = -1L;
    private MonitorDataSourceSummary summary = new MonitorDataSourceSummary();

    public MonitorDataSource() {
        MonitorDataSourceManager.instance().register(this);
    }

    public MonitorDataSource(DataSource dataSource) {
        this();
        this.dataSource = dataSource;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public boolean isEnableMonitorStatement() {
        return this.enableMonitorStatement;
    }

    public void setEnableMonitorStatement(boolean enableMonitorStatement) {
        this.enableMonitorStatement = enableMonitorStatement;
    }

    public long getReleaseAlarmThreshold() {
        return this.releaseAlarmThreshold;
    }

    public void setReleaseAlarmThreshold(long releaseAlarmThreshold) {
        this.releaseAlarmThreshold = releaseAlarmThreshold;
    }

    public long getBlockingThreshold() {
        return this.blockingThreshold;
    }

    public void setBlockingThreshold(long blockingThreshold) {
        this.blockingThreshold = blockingThreshold;
    }

    public long getExecuteBlockingThreshold() {
        return this.executeBlockingThreshold;
    }

    public void setExecuteBlockingThreshold(long executeBlockingThreshold) {
        this.executeBlockingThreshold = executeBlockingThreshold;
    }

    public MonitorDataSourceSummary getSummary() {
        return this.summary;
    }

    public Collection<MonitorConnection> getMonitorConnections() {
        return Collections.unmodifiableCollection(this.allMonitors.values());
    }

    public Collection<MonitorConnection> getBlockingMonitorConnections() {
        if (this.blockingThreshold == -1L) {
            return Collections.emptyList();
        }
        ArrayList<MonitorConnection> list = new ArrayList<MonitorConnection>();
        long now = System.currentTimeMillis();
        for (MonitorConnection monitor : this.allMonitors.values()) {
            if (monitor.getConnection() != null || now - monitor.getCreatedTime().getTime() <= this.blockingThreshold) continue;
            list.add(monitor);
        }
        return list;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.dataSource.getLogWriter();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.dataSource.unwrap(iface);
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.dataSource.setLogWriter(out);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.dataSource.isWrapperFor(iface);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.dataSource.setLoginTimeout(seconds);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnectionCore(false, null, null);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnectionCore(true, username, password);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.dataSource.getLoginTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection getConnectionCore(boolean hasPassword, String username, String password) throws SQLException {
        MonitorConnection monitor = this.createMonitorConnection();
        this.allMonitors.put(monitor, monitor);
        this.beforeGetConnection(monitor.getId());
        Connection connection = null;
        long now = System.currentTimeMillis();
        try {
            connection = hasPassword ? this.dataSource.getConnection(username, password) : this.dataSource.getConnection();
        }
        finally {
            this.afterGetConnection(monitor.getId(), connection, System.currentTimeMillis() - now);
            if (connection != null) {
                this.connections.put(connection, monitor);
                monitor.setConnection(connection);
                monitor.setProxyTime(new Date());
                connection = monitor.getProxy();
            } else {
                this.allMonitors.remove(monitor);
            }
        }
        return connection;
    }

    protected void beforeGetConnection(long id) {
        if (this.blockingThreshold != -1L && logger.isDebugEnabled()) {
            logger.debug("[" + id + "]before getConnection");
        }
    }

    protected void afterGetConnection(long id, Connection connection, long timespan) {
        if (connection != null) {
            this.summary.incrementUsed();
            this.summary.incrementFetchCount();
            if (this.blockingThreshold != -1L && timespan > this.blockingThreshold) {
                this.summary.incrementFetchAlarmCount();
                if (logger.isInfoEnabled()) {
                    Thread thread = Thread.currentThread();
                    String stack = DebugUtils.getShortStackTrace(thread.getStackTrace());
                    logger.info("[" + id + "]getConnection in " + timespan + " miliseconds\n" + stack);
                }
            }
        }
    }

    protected void releaseConnection(Connection connection) {
        long timespan;
        MonitorConnection mConn = this.connections.remove(connection);
        if (mConn == null) {
            return;
        }
        this.allMonitors.remove(mConn);
        this.summary.decrementUsed();
        if (logger.isDebugEnabled()) {
            logger.debug("[" + mConn.getId() + "]release connection,dsName:" + this.name);
        }
        if (this.releaseAlarmThreshold != -1L && (timespan = System.currentTimeMillis() - mConn.getCreatedTime().getTime()) > this.releaseAlarmThreshold) {
            this.summary.incrementReleaseAlarmCount();
            if (logger.isInfoEnabled()) {
                Thread thread = Thread.currentThread();
                String stack = DebugUtils.getShortStackTrace(thread.getStackTrace());
                logger.info("[" + mConn.getId() + "]use connection in " + timespan + " miliseconds\n" + stack);
            }
        }
    }

    private MonitorConnection createMonitorConnection() {
        MonitorConnection mConn = new MonitorConnection(this);
        mConn.setId(SEQ.incrementAndGet());
        mConn.setOwnerThread(Thread.currentThread());
        mConn.setCreatedTime(new Date());
        mConn.setThreadStack(DebugUtils.getStackTrace(Thread.currentThread().getStackTrace()));
        mConn.setStatus("init");
        return mConn;
    }
}

