/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common.datasource;

import com.mchange.v2.c3p0.PooledDataSource;
import com.yeepay.g3.utils.common.AssertUtils;
import com.yeepay.g3.utils.common.DebugUtils;
import com.yeepay.g3.utils.common.datasource.MonitorConnection;
import com.yeepay.g3.utils.common.datasource.MonitorDataSource;
import com.yeepay.g3.utils.common.datasource.YeepayComboPooledDataSource;
import com.yeepay.g3.utils.common.log.Logger;
import com.yeepay.g3.utils.common.log.LoggerFactory;
import com.yeepay.g3.utils.common.monitor.ListableServiceMonitor;
import com.yeepay.g3.utils.common.monitor.ServiceMonitorRegister;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class MonitorDataSourceManager {
    private static final Logger logger = LoggerFactory.getLogger(MonitorDataSourceManager.class);
    private static volatile MonitorDataSourceManager INSTANCE = null;
    private static Object LOCK = new Object();
    private WeakHashMap<MonitorDataSource, MonitorDataSource> monitors = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MonitorDataSourceManager instance() {
        if (INSTANCE == null) {
            Object object = LOCK;
            synchronized (object) {
                if (INSTANCE == null) {
                    INSTANCE = new MonitorDataSourceManager();
                }
            }
        }
        return INSTANCE;
    }

    public MonitorDataSourceManager() {
        this.registerToServiceMonitorRegister();
        this.registerToServiceMonitorRegisterSummary();
    }

    protected synchronized void register(MonitorDataSource monitorDataSource) {
        AssertUtils.isTrue(!this.monitors.containsKey(monitorDataSource), "MonitorDataSource\u91cd\u590d\u6ce8\u518c");
        this.monitors.put(monitorDataSource, monitorDataSource);
    }

    private void registerToServiceMonitorRegister() {
        ServiceMonitorRegister.registListableServiceMonitor("monitor-connection", new ListableServiceMonitor(){

            @Override
            public List<?> getAllServiceStatus() {
                return MonitorDataSourceManager.this.getDetailsStatus(null);
            }

            @Override
            public Object getServiceStatus(String serviceName) {
                if ("summary".equals(serviceName)) {
                    return MonitorDataSourceManager.this.getSummaryStatus(null);
                }
                if ("c3p0".equals(serviceName)) {
                    return MonitorDataSourceManager.this.getC3p0Status();
                }
                return MonitorDataSourceManager.this.tile(MonitorDataSourceManager.this.getDetailsStatus(serviceName));
            }
        });
    }

    private void registerToServiceMonitorRegisterSummary() {
        ServiceMonitorRegister.registListableServiceMonitor("monitor-datasource-summary", new ListableServiceMonitor(){

            @Override
            public List<?> getAllServiceStatus() {
                ArrayList<Object> list = new ArrayList<Object>();
                for (String item : MonitorDataSourceManager.this.getMonitorDataSourceNames()) {
                    list.add(MonitorDataSourceManager.this.getSummaryStatus(item));
                }
                return list;
            }

            @Override
            public Object getServiceStatus(String serviceName) {
                return MonitorDataSourceManager.this.getSummaryStatus(serviceName);
            }
        });
    }

    private List<Map<String, Object>> getDetailsStatus(String dsName) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:S");
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (MonitorDataSource monitor : this.findMonitorDataSource(dsName)) {
            for (MonitorConnection connection : monitor.getMonitorConnections()) {
                HashMap<String, Object> status = new HashMap<String, Object>();
                status.put("ds-name", connection.getMonitorDataSource().getName());
                status.put("thread-name", connection.getOwnerThread().getName());
                status.put("thread-id", connection.getOwnerThread().getId());
                status.put("created-time", format.format(connection.getCreatedTime()));
                if (connection.getProxyTime() != null) {
                    status.put("proxy-time", format.format(connection.getProxyTime()));
                } else {
                    status.put("proxy-time", "");
                }
                status.put("stacktrace", connection.getThreadStack());
                status.put("thread-current-stacktrace", DebugUtils.getStackTrace(connection.getOwnerThread().getStackTrace()));
                status.put("before-get-connection", connection.getConnection() == null);
                list.add(status);
            }
        }
        return list;
    }

    private Object getSummaryStatus(String dsName) {
        long used = 0L;
        long fetchAlarmCount = 0L;
        long releaseAlarmCount = 0L;
        long fetchCount = 0L;
        long blockingCount = 0L;
        long numBusyConnectionsAllUsers = 0L;
        long numIdleConnectionsAllUsers = 0L;
        long numUnclosedOrphanedConnectionsAllUsers = 0L;
        long maxPoolSize = 0L;
        for (MonitorDataSource monitor : this.findMonitorDataSource(dsName)) {
            used += monitor.getSummary().getUsed();
            fetchAlarmCount += monitor.getSummary().getFetchAlarmCount();
            releaseAlarmCount += monitor.getSummary().getReleaseAlarmCount();
            fetchCount += monitor.getSummary().getFetchCount();
            blockingCount += (long)monitor.getBlockingMonitorConnections().size();
            if (!(monitor.getDataSource() instanceof YeepayComboPooledDataSource)) continue;
            YeepayComboPooledDataSource pooledDataSource = (YeepayComboPooledDataSource)((Object)monitor.getDataSource());
            try {
                numBusyConnectionsAllUsers += (long)pooledDataSource.getNumBusyConnectionsAllUsers();
                numIdleConnectionsAllUsers += (long)pooledDataSource.getNumIdleConnectionsAllUsers();
                numUnclosedOrphanedConnectionsAllUsers += (long)pooledDataSource.getNumUnclosedOrphanedConnectionsAllUsers();
                maxPoolSize += (long)pooledDataSource.getMaxPoolSize();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        HashMap<String, Object> hashmap = new HashMap<String, Object>();
        hashmap.put("dsName", dsName);
        hashmap.put("used", used);
        hashmap.put("fetchAlarmCount", fetchAlarmCount);
        hashmap.put("releaseAlarmCount", releaseAlarmCount);
        hashmap.put("fetchCount", fetchCount);
        hashmap.put("blockingCount", blockingCount);
        hashmap.put("numBusyConnectionsAllUsers", numBusyConnectionsAllUsers);
        hashmap.put("numIdleConnectionsAllUsers", numIdleConnectionsAllUsers);
        hashmap.put("numUnclosedOrphanedConnectionsAllUsers", numUnclosedOrphanedConnectionsAllUsers);
        hashmap.put("maxPoolSize", maxPoolSize);
        return hashmap;
    }

    private Object getC3p0Status() {
        int numBusyConnectionsAllUsers = 0;
        int numIdleConnectionsAllUsers = 0;
        int numUnclosedOrphanedConnectionsAllUsers = 0;
        int threadPoolNumActiveThreads = 0;
        int threadPoolNumIdleThreads = 0;
        int threadPoolNumTasksPending = 0;
        int threadPoolSize = 0;
        for (MonitorDataSource monitor : this.monitors.values()) {
            if (!(monitor.getDataSource() instanceof PooledDataSource)) continue;
            PooledDataSource pooledDataSource = (PooledDataSource)monitor.getDataSource();
            try {
                numBusyConnectionsAllUsers += pooledDataSource.getNumBusyConnectionsAllUsers();
                numIdleConnectionsAllUsers += pooledDataSource.getNumIdleConnectionsAllUsers();
                numUnclosedOrphanedConnectionsAllUsers += pooledDataSource.getNumUnclosedOrphanedConnectionsAllUsers();
                threadPoolNumActiveThreads += pooledDataSource.getThreadPoolNumActiveThreads();
                threadPoolNumIdleThreads += pooledDataSource.getThreadPoolNumIdleThreads();
                threadPoolNumTasksPending += pooledDataSource.getThreadPoolNumTasksPending();
                threadPoolSize += pooledDataSource.getThreadPoolSize();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        HashMap<String, Integer> hashmap = new HashMap<String, Integer>();
        hashmap.put("numBusyConnectionsAllUsers", numBusyConnectionsAllUsers);
        hashmap.put("numIdleConnectionsAllUsers", numIdleConnectionsAllUsers);
        hashmap.put("numUnclosedOrphanedConnectionsAllUsers", numUnclosedOrphanedConnectionsAllUsers);
        hashmap.put("threadPoolNumActiveThreads", threadPoolNumActiveThreads);
        hashmap.put("threadPoolNumIdleThreads", threadPoolNumIdleThreads);
        hashmap.put("threadPoolNumTasksPending", threadPoolNumTasksPending);
        hashmap.put("threadPoolSize", threadPoolSize);
        return hashmap;
    }

    private HashMap<String, Object> tile(List<Map<String, Object>> list) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Object> item = list.get(i);
            for (Map.Entry<String, Object> entry : item.entrySet()) {
                data.put(i + "." + entry.getKey(), entry.getValue());
            }
        }
        return data;
    }

    private synchronized List<MonitorDataSource> findMonitorDataSource(String dsName) {
        if (dsName == null || dsName.trim().length() == 0) {
            return new ArrayList<MonitorDataSource>(this.monitors.values());
        }
        ArrayList<MonitorDataSource> list = new ArrayList<MonitorDataSource>();
        for (MonitorDataSource monitor : this.monitors.values()) {
            if (!dsName.equals(monitor.getName())) continue;
            list.add(monitor);
        }
        return list;
    }

    private synchronized HashSet<String> getMonitorDataSourceNames() {
        HashSet<String> hashset = new HashSet<String>();
        for (MonitorDataSource monitor : this.monitors.values()) {
            hashset.add(monitor.getName());
        }
        return hashset;
    }
}

