/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common.datasource;

import com.yeepay.g3.utils.common.DebugUtils;
import com.yeepay.g3.utils.common.datasource.MonitorConnection;
import com.yeepay.g3.utils.common.datasource.MonitorDataSource;
import com.yeepay.g3.utils.common.datasource.MonitorUtils;
import com.yeepay.g3.utils.common.log.Logger;
import com.yeepay.g3.utils.common.log.LoggerFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;

public class MonitorStatement
implements InvocationHandler {
    private static final Logger logger = LoggerFactory.getLogger(MonitorStatement.class);
    private static List<String> LIST = Arrays.asList("execute", "executeQuery", "executeUpdate");
    private MonitorConnection monitorConnection;
    private MonitorDataSource monitorDataSource;
    private String preparedSql;
    private Statement statement;
    private Statement proxy;
    private String executingSql;
    private long executeStartTime;
    private Thread executeThread;
    private String executeStackTrace;

    public MonitorStatement(MonitorConnection monitorConnection, MonitorDataSource monitorDataSource, String preparedSql, Statement statement) {
        this.monitorConnection = monitorConnection;
        this.monitorDataSource = monitorDataSource;
        this.preparedSql = preparedSql;
        this.statement = statement;
    }

    public Statement getProxy() {
        if (this.proxy == null) {
            this.proxy = this.preparedSql != null ? (Statement)MonitorUtils.createJdkProxy((InvocationHandler)this, PreparedStatement.class) : MonitorUtils.createJdkProxy((InvocationHandler)this, Statement.class);
        }
        return this.proxy;
    }

    public String getExecutingSql() {
        return this.executingSql;
    }

    public long getExecuteStartTime() {
        return this.executeStartTime;
    }

    public Thread getExecuteThread() {
        return this.executeThread;
    }

    public String getExecuteStackTrace() {
        return this.executeStackTrace;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (LIST.contains(methodName)) {
            return this.onExecute(method, args);
        }
        if ("close".equals(methodName)) {
            this.close();
            return null;
        }
        try {
            return method.invoke((Object)this.statement, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        try {
            this.statement.close();
        }
        finally {
            this.monitorConnection.releaseStatement(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object onExecute(Method method, Object[] args) throws Throwable {
        this.executingSql = this.getSqlParameter(args);
        this.executeStartTime = System.currentTimeMillis();
        this.executeThread = Thread.currentThread();
        this.executeStackTrace = DebugUtils.getStackTrace(this.executeThread.getStackTrace());
        this.onBeforeExecute();
        try {
            Object object = MonitorUtils.invoke(method, this.statement, args);
            return object;
        }
        finally {
            this.onAfterExecute();
            this.executingSql = null;
        }
    }

    protected void onBeforeExecute() {
        if (logger.isInfoEnabled()) {
            logger.info("[" + this.monitorConnection.getId() + "]ready for execute sql.");
        }
    }

    protected void onAfterExecute() {
        long timespan = System.currentTimeMillis() - this.executeStartTime;
        if (this.monitorDataSource.getExecuteBlockingThreshold() != -1L && timespan >= this.monitorDataSource.getExecuteBlockingThreshold()) {
            if (logger.isInfoEnabled()) {
                logger.info("[" + this.monitorConnection.getId() + "]after executed sql, use " + timespan + " miliseconds");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("[" + this.monitorConnection.getId() + "] executed sql:" + this.executingSql);
            }
        }
    }

    private String getSqlParameter(Object[] args) {
        String sql = null;
        if (args != null && args.length > 0) {
            sql = (String)args[0];
        }
        if (sql == null) {
            sql = this.preparedSql;
        }
        return sql;
    }
}

