/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common.datasource;

import com.yeepay.g3.utils.common.datasource.Config;
import com.yeepay.g3.utils.common.datasource.FileLoader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.dbcp.BasicDataSource;

public class YeepayDBCPDataSourceWrapper
extends BasicDataSource {
    private static String DEFAULT_DIEVERCLASS = "com.ibm.db2.jcc.DB2Driver";
    private String dsFile;

    public YeepayDBCPDataSourceWrapper() {
        this.setDriverClassName(DEFAULT_DIEVERCLASS);
    }

    public void setDsFile(String dsFile) {
        this.dsFile = dsFile;
        this.doConfig();
    }

    private void doConfig() {
        try {
            InputStream is = FileLoader.loadFile("db/" + this.dsFile + ".properties");
            Properties prop = new Properties();
            prop.load(is);
            Config config = Config.instance(prop);
            if (config.getDriverClass() != null) {
                this.setDriverClassName(config.getDriverClass());
            }
            if (config.getJdbcUrl() != null) {
                this.setUrl(config.getJdbcUrl());
            }
            if (config.getUser() != null) {
                this.setUsername(config.getUser());
            }
            if (config.getPassword() != null) {
                this.setPassword(config.getPassword());
            }
            if (config.getSchema() != null) {
                this.addConnectionProperty("currentSchema", config.getSchema());
            }
            this.setInitialSize(config.getMinPoolSize());
            this.setMaxActive(config.getMaxPoolSize());
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setSchema(String schema) {
        this.addConnectionProperty("currentSchema", schema);
    }
}

