/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common.encrypt;

import com.yeepay.g3.utils.common.CheckUtils;
import com.yeepay.g3.utils.common.encrypt.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class DESede {
    public static byte[] encrypt(byte[] data, byte[] key) {
        CheckUtils.notEmpty(data, "data");
        CheckUtils.notEmpty(key, "key");
        if (key.length != 24) {
            throw new RuntimeException("Invalid DESede key length (must be 24 bytes)");
        }
        try {
            SecretKeySpec deskey = new SecretKeySpec(key, "DESede");
            Cipher c1 = Cipher.getInstance("DESede");
            c1.init(1, deskey);
            return c1.doFinal(data);
        }
        catch (Exception e) {
            throw new RuntimeException("encrypt fail!", e);
        }
    }

    public static byte[] decrypt(byte[] data, byte[] key) {
        CheckUtils.notEmpty(data, "data");
        CheckUtils.notEmpty(key, "key");
        if (key.length != 24) {
            throw new RuntimeException("Invalid DESede key length (must be 24 bytes)");
        }
        try {
            SecretKeySpec deskey = new SecretKeySpec(key, "DESede");
            Cipher c1 = Cipher.getInstance("DESede");
            c1.init(2, deskey);
            return c1.doFinal(data);
        }
        catch (Exception e) {
            throw new RuntimeException("decrypt fail!", e);
        }
    }

    public static String encryptToBase64(String data, String key) {
        try {
            byte[] keyByte = key.getBytes("UTF-8");
            byte[] dataByte = data.getBytes("UTF-8");
            byte[] valueByte = DESede.encrypt(dataByte, keyByte);
            return new String(Base64.encode(valueByte));
        }
        catch (Exception e) {
            throw new RuntimeException("encrypt fail!", e);
        }
    }

    public static String decryptFromBase64(String data, String key) {
        try {
            byte[] keyByte = key.getBytes("UTF-8");
            byte[] valueByte = Base64.decode(data.getBytes());
            byte[] dataByte = DESede.decrypt(valueByte, keyByte);
            String str = new String(dataByte, "UTF-8");
            return str;
        }
        catch (Exception e) {
            throw new RuntimeException("decrypt fail!", e);
        }
    }
}

