/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common.encrypt.pki;

import com.yeepay.g3.utils.common.CheckUtils;
import com.yeepay.g3.utils.common.encrypt.AES;
import com.yeepay.g3.utils.common.encrypt.Base64;
import com.yeepay.g3.utils.common.encrypt.HmacSign;
import com.yeepay.g3.utils.common.encrypt.pki.RSA;
import java.io.UnsupportedEncodingException;
import java.security.PrivateKey;
import java.security.PublicKey;

public class DigitalEnvelopeUtils {
    public static String encrypt(String source, PrivateKey privateKey, PublicKey publicKey) {
        CheckUtils.notEmpty(source, "source data");
        CheckUtils.notEmpty(privateKey, "privateKey");
        CheckUtils.notEmpty(publicKey, "publicKey");
        byte[] data = null;
        try {
            data = source.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("encrypt fail!", e);
        }
        byte[] randomKey = AES.genarateRandomKey();
        byte[] encryptedRandomKey = RSA.encrypt(randomKey, publicKey);
        String encryptedRandomKeyToBase64 = new String(Base64.encode(encryptedRandomKey));
        byte[] encryptedData = AES.encrypt(data, randomKey);
        String encryptedDataToBase64 = new String(Base64.encode(encryptedData));
        byte[] sign = RSA.sign(data, privateKey);
        String signToBase64 = new String(Base64.encode(sign));
        String envelopeData = encryptedRandomKeyToBase64 + "$" + encryptedDataToBase64 + "$" + signToBase64;
        String hmacSignToBase64 = null;
        try {
            byte[] hmacSign = HmacSign.sign(envelopeData.getBytes("UTF-8"), randomKey);
            hmacSignToBase64 = new String(Base64.encode(hmacSign));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("encrypt fail!", e);
        }
        return envelopeData + "$" + hmacSignToBase64;
    }

    public static String decrypt(String source, PrivateKey privateKey, PublicKey publicKey) {
        CheckUtils.notEmpty(source, "source data");
        CheckUtils.notEmpty(privateKey, "privateKey");
        CheckUtils.notEmpty(publicKey, "publicKey");
        String[] args = source.split("\\$");
        if (args.length != 4) {
            throw new RuntimeException("source invalid : " + source);
        }
        String encryptedRandomKeyToBase64 = args[0];
        String encryptedDataToBase64 = args[1];
        String signToBase64 = args[2];
        String hmacSignToBase64 = args[3];
        if (CheckUtils.isEmpty(encryptedRandomKeyToBase64) || CheckUtils.isEmpty(encryptedDataToBase64) || CheckUtils.isEmpty(signToBase64) || CheckUtils.isEmpty(hmacSignToBase64)) {
            throw new RuntimeException("source invalid : " + source);
        }
        byte[] randomKey = RSA.decrypt(Base64.decode(encryptedRandomKeyToBase64.getBytes()), privateKey);
        try {
            String envelopeData = encryptedRandomKeyToBase64 + "$" + encryptedDataToBase64 + "$" + signToBase64;
            byte[] hmacSign = HmacSign.sign(envelopeData.getBytes("UTF-8"), randomKey);
            if (!new String(Base64.encode(hmacSign)).equals(hmacSignToBase64)) {
                throw new RuntimeException("verify hmacsign fail!");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("decrypt fail!", e);
        }
        byte[] sourceData = AES.decrypt(Base64.decode(encryptedDataToBase64.getBytes()), randomKey);
        boolean verifySign = RSA.verifySign(sourceData, Base64.decode(signToBase64.getBytes()), publicKey);
        if (!verifySign) {
            throw new RuntimeException("verifySign fail!");
        }
        try {
            return new String(sourceData, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("decrypt fail!");
        }
    }
}

