/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.utils.common.encrypt.pki;

import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class KeyUtils {
    private static final String PUBLIC_KEY = "RSAPublicKey";
    private static final String PRIVATE_KEY = "RSAPrivateKey";

    public static CertPath getCertificateChain(InputStream is) {
        if (is == null) {
            throw new IllegalArgumentException("no certificate inputstream specified !!");
        }
        CertPath certpath = null;
        try {
            CertPath path;
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(is);
            ArrayList<X509Certificate> caCertsList = new ArrayList<X509Certificate>();
            caCertsList.add(cert);
            CertPath certPath = certpath = (path = cf.generateCertPath(caCertsList));
            return certPath;
        }
        catch (Exception e) {
            throw new RuntimeException("get certificateChain fail!", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static X509Certificate getCertificate(InputStream is) throws CertificateException {
        if (is == null) {
            throw new IllegalArgumentException("no certificate inputstream specified !!");
        }
        X509Certificate cert = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X509");
            X509Certificate x509Certificate = cert = (X509Certificate)cf.generateCertificate(is);
            return x509Certificate;
        }
        catch (Exception e) {
            throw new RuntimeException("get certificate fail!", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static PrivateKey getPrivateKey(KeyStore keyStore, String alias, String password) {
        try {
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, password.toCharArray());
            return privateKey;
        }
        catch (Exception e) {
            throw new RuntimeException("get PrivateKey fail!", e);
        }
    }

    public static KeyStore getKeyStore(InputStream is, String keyStorePass, String keyStoreType) {
        if (is == null) {
            throw new IllegalArgumentException("no keystore inputstream specified !!");
        }
        if (keyStorePass == null) {
            throw new IllegalArgumentException("no keyStorePass specified !!");
        }
        if (keyStoreType == null) {
            throw new IllegalArgumentException("no keyStoreType specified !!");
        }
        try {
            KeyStore keystore = KeyStore.getInstance(keyStoreType);
            keystore.load(is, keyStorePass.toCharArray());
            KeyStore keyStore = keystore;
            return keyStore;
        }
        catch (Exception e) {
            throw new RuntimeException("get KeyStore fail!", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static Map<String, Object> initKey() throws Exception {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
        keyPairGen.initialize(1024);
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        HashMap<String, Object> keyMap = new HashMap<String, Object>(2);
        keyMap.put(PUBLIC_KEY, publicKey);
        keyMap.put(PRIVATE_KEY, privateKey);
        return keyMap;
    }

    public static Key getPrivateKey(Map<String, Object> keyMap) throws Exception {
        Key key = (Key)keyMap.get(PRIVATE_KEY);
        return key;
    }

    public static Key getPublicKey(Map<String, Object> keyMap) throws Exception {
        Key key = (Key)keyMap.get(PUBLIC_KEY);
        return key;
    }
}

